// Code generated by go-swagger; DO NOT EDIT.

package org_preferences

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PatchOrgPreferencesReader is a Reader for the PatchOrgPreferences structure.
type PatchOrgPreferencesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PatchOrgPreferencesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPatchOrgPreferencesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPatchOrgPreferencesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewPatchOrgPreferencesUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPatchOrgPreferencesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPatchOrgPreferencesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /org/preferences] patchOrgPreferences", response, response.Code())
	}
}

// NewPatchOrgPreferencesOK creates a PatchOrgPreferencesOK with default headers values
func NewPatchOrgPreferencesOK() *PatchOrgPreferencesOK {
	return &PatchOrgPreferencesOK{}
}

/*
PatchOrgPreferencesOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type PatchOrgPreferencesOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this patch org preferences Ok response has a 2xx status code
func (o *PatchOrgPreferencesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this patch org preferences Ok response has a 3xx status code
func (o *PatchOrgPreferencesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch org preferences Ok response has a 4xx status code
func (o *PatchOrgPreferencesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch org preferences Ok response has a 5xx status code
func (o *PatchOrgPreferencesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this patch org preferences Ok response a status code equal to that given
func (o *PatchOrgPreferencesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the patch org preferences Ok response
func (o *PatchOrgPreferencesOK) Code() int {
	return 200
}

func (o *PatchOrgPreferencesOK) Error() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesOk  %+v", 200, o.Payload)
}

func (o *PatchOrgPreferencesOK) String() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesOk  %+v", 200, o.Payload)
}

func (o *PatchOrgPreferencesOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *PatchOrgPreferencesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchOrgPreferencesBadRequest creates a PatchOrgPreferencesBadRequest with default headers values
func NewPatchOrgPreferencesBadRequest() *PatchOrgPreferencesBadRequest {
	return &PatchOrgPreferencesBadRequest{}
}

/*
PatchOrgPreferencesBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type PatchOrgPreferencesBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this patch org preferences bad request response has a 2xx status code
func (o *PatchOrgPreferencesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch org preferences bad request response has a 3xx status code
func (o *PatchOrgPreferencesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch org preferences bad request response has a 4xx status code
func (o *PatchOrgPreferencesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch org preferences bad request response has a 5xx status code
func (o *PatchOrgPreferencesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this patch org preferences bad request response a status code equal to that given
func (o *PatchOrgPreferencesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the patch org preferences bad request response
func (o *PatchOrgPreferencesBadRequest) Code() int {
	return 400
}

func (o *PatchOrgPreferencesBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesBadRequest  %+v", 400, o.Payload)
}

func (o *PatchOrgPreferencesBadRequest) String() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesBadRequest  %+v", 400, o.Payload)
}

func (o *PatchOrgPreferencesBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PatchOrgPreferencesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchOrgPreferencesUnauthorized creates a PatchOrgPreferencesUnauthorized with default headers values
func NewPatchOrgPreferencesUnauthorized() *PatchOrgPreferencesUnauthorized {
	return &PatchOrgPreferencesUnauthorized{}
}

/*
PatchOrgPreferencesUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type PatchOrgPreferencesUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this patch org preferences unauthorized response has a 2xx status code
func (o *PatchOrgPreferencesUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch org preferences unauthorized response has a 3xx status code
func (o *PatchOrgPreferencesUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch org preferences unauthorized response has a 4xx status code
func (o *PatchOrgPreferencesUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch org preferences unauthorized response has a 5xx status code
func (o *PatchOrgPreferencesUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this patch org preferences unauthorized response a status code equal to that given
func (o *PatchOrgPreferencesUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the patch org preferences unauthorized response
func (o *PatchOrgPreferencesUnauthorized) Code() int {
	return 401
}

func (o *PatchOrgPreferencesUnauthorized) Error() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesUnauthorized  %+v", 401, o.Payload)
}

func (o *PatchOrgPreferencesUnauthorized) String() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesUnauthorized  %+v", 401, o.Payload)
}

func (o *PatchOrgPreferencesUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PatchOrgPreferencesUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchOrgPreferencesForbidden creates a PatchOrgPreferencesForbidden with default headers values
func NewPatchOrgPreferencesForbidden() *PatchOrgPreferencesForbidden {
	return &PatchOrgPreferencesForbidden{}
}

/*
PatchOrgPreferencesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type PatchOrgPreferencesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this patch org preferences forbidden response has a 2xx status code
func (o *PatchOrgPreferencesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch org preferences forbidden response has a 3xx status code
func (o *PatchOrgPreferencesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch org preferences forbidden response has a 4xx status code
func (o *PatchOrgPreferencesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this patch org preferences forbidden response has a 5xx status code
func (o *PatchOrgPreferencesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this patch org preferences forbidden response a status code equal to that given
func (o *PatchOrgPreferencesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the patch org preferences forbidden response
func (o *PatchOrgPreferencesForbidden) Code() int {
	return 403
}

func (o *PatchOrgPreferencesForbidden) Error() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesForbidden  %+v", 403, o.Payload)
}

func (o *PatchOrgPreferencesForbidden) String() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesForbidden  %+v", 403, o.Payload)
}

func (o *PatchOrgPreferencesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PatchOrgPreferencesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchOrgPreferencesInternalServerError creates a PatchOrgPreferencesInternalServerError with default headers values
func NewPatchOrgPreferencesInternalServerError() *PatchOrgPreferencesInternalServerError {
	return &PatchOrgPreferencesInternalServerError{}
}

/*
PatchOrgPreferencesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type PatchOrgPreferencesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this patch org preferences internal server error response has a 2xx status code
func (o *PatchOrgPreferencesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this patch org preferences internal server error response has a 3xx status code
func (o *PatchOrgPreferencesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this patch org preferences internal server error response has a 4xx status code
func (o *PatchOrgPreferencesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this patch org preferences internal server error response has a 5xx status code
func (o *PatchOrgPreferencesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this patch org preferences internal server error response a status code equal to that given
func (o *PatchOrgPreferencesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the patch org preferences internal server error response
func (o *PatchOrgPreferencesInternalServerError) Code() int {
	return 500
}

func (o *PatchOrgPreferencesInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesInternalServerError  %+v", 500, o.Payload)
}

func (o *PatchOrgPreferencesInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /org/preferences][%d] patchOrgPreferencesInternalServerError  %+v", 500, o.Payload)
}

func (o *PatchOrgPreferencesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PatchOrgPreferencesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
