// Code generated by go-swagger; DO NOT EDIT.

package org

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new org API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for org API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AddOrgUserToCurrentOrg(body *models.AddOrgUserCommand, opts ...ClientOption) (*AddOrgUserToCurrentOrgOK, error)
	AddOrgUserToCurrentOrgWithParams(params *AddOrgUserToCurrentOrgParams, opts ...ClientOption) (*AddOrgUserToCurrentOrgOK, error)

	GetCurrentOrg(opts ...ClientOption) (*GetCurrentOrgOK, error)
	GetCurrentOrgWithParams(params *GetCurrentOrgParams, opts ...ClientOption) (*GetCurrentOrgOK, error)

	GetOrgUsersForCurrentOrg(opts ...ClientOption) (*GetOrgUsersForCurrentOrgOK, error)
	GetOrgUsersForCurrentOrgWithParams(params *GetOrgUsersForCurrentOrgParams, opts ...ClientOption) (*GetOrgUsersForCurrentOrgOK, error)

	GetOrgUsersForCurrentOrgLookup(params *GetOrgUsersForCurrentOrgLookupParams, opts ...ClientOption) (*GetOrgUsersForCurrentOrgLookupOK, error)

	RemoveOrgUserForCurrentOrg(userID int64, opts ...ClientOption) (*RemoveOrgUserForCurrentOrgOK, error)
	RemoveOrgUserForCurrentOrgWithParams(params *RemoveOrgUserForCurrentOrgParams, opts ...ClientOption) (*RemoveOrgUserForCurrentOrgOK, error)

	UpdateCurrentOrg(body *models.UpdateOrgForm, opts ...ClientOption) (*UpdateCurrentOrgOK, error)
	UpdateCurrentOrgWithParams(params *UpdateCurrentOrgParams, opts ...ClientOption) (*UpdateCurrentOrgOK, error)

	UpdateCurrentOrgAddress(body *models.UpdateOrgAddressForm, opts ...ClientOption) (*UpdateCurrentOrgAddressOK, error)
	UpdateCurrentOrgAddressWithParams(params *UpdateCurrentOrgAddressParams, opts ...ClientOption) (*UpdateCurrentOrgAddressOK, error)

	UpdateOrgUserForCurrentOrg(userID int64, body *models.UpdateOrgUserCommand, opts ...ClientOption) (*UpdateOrgUserForCurrentOrgOK, error)
	UpdateOrgUserForCurrentOrgWithParams(params *UpdateOrgUserForCurrentOrgParams, opts ...ClientOption) (*UpdateOrgUserForCurrentOrgOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AddOrgUserToCurrentOrg adds a new user to the current organization

Adds a global user to the current organization.

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `org.users:add` with scope `users:*`.
*/
func (a *Client) AddOrgUserToCurrentOrg(body *models.AddOrgUserCommand, opts ...ClientOption) (*AddOrgUserToCurrentOrgOK, error) {
	params := NewAddOrgUserToCurrentOrgParams().WithBody(body)
	return a.AddOrgUserToCurrentOrgWithParams(params, opts...)
}

func (a *Client) AddOrgUserToCurrentOrgWithParams(params *AddOrgUserToCurrentOrgParams, opts ...ClientOption) (*AddOrgUserToCurrentOrgOK, error) {
	if params == nil {
		params = NewAddOrgUserToCurrentOrgParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "addOrgUserToCurrentOrg",
		Method:             "POST",
		PathPattern:        "/org/users",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &AddOrgUserToCurrentOrgReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AddOrgUserToCurrentOrgOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for addOrgUserToCurrentOrg: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetCurrentOrg gets current organization
*/
func (a *Client) GetCurrentOrg(opts ...ClientOption) (*GetCurrentOrgOK, error) {
	params := NewGetCurrentOrgParams()
	return a.GetCurrentOrgWithParams(params, opts...)
}

func (a *Client) GetCurrentOrgWithParams(params *GetCurrentOrgParams, opts ...ClientOption) (*GetCurrentOrgOK, error) {
	if params == nil {
		params = NewGetCurrentOrgParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getCurrentOrg",
		Method:             "GET",
		PathPattern:        "/org",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetCurrentOrgReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetCurrentOrgOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getCurrentOrg: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetOrgUsersForCurrentOrg gets all users within the current organization

Returns all org users within the current organization. Accessible to users with org admin role.
If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `org.users:read` with scope `users:*`.
*/
func (a *Client) GetOrgUsersForCurrentOrg(opts ...ClientOption) (*GetOrgUsersForCurrentOrgOK, error) {
	params := NewGetOrgUsersForCurrentOrgParams()
	return a.GetOrgUsersForCurrentOrgWithParams(params, opts...)
}

func (a *Client) GetOrgUsersForCurrentOrgWithParams(params *GetOrgUsersForCurrentOrgParams, opts ...ClientOption) (*GetOrgUsersForCurrentOrgOK, error) {
	if params == nil {
		params = NewGetOrgUsersForCurrentOrgParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getOrgUsersForCurrentOrg",
		Method:             "GET",
		PathPattern:        "/org/users",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetOrgUsersForCurrentOrgReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetOrgUsersForCurrentOrgOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getOrgUsersForCurrentOrg: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetOrgUsersForCurrentOrgLookup gets all users within the current organization lookup

Returns all org users within the current organization, but with less detailed information.
Accessible to users with org admin role, admin in any folder or admin of any team.
Mainly used by Grafana UI for providing list of users when adding team members and when editing folder/dashboard permissions.
*/

func (a *Client) GetOrgUsersForCurrentOrgLookup(params *GetOrgUsersForCurrentOrgLookupParams, opts ...ClientOption) (*GetOrgUsersForCurrentOrgLookupOK, error) {
	if params == nil {
		params = NewGetOrgUsersForCurrentOrgLookupParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getOrgUsersForCurrentOrgLookup",
		Method:             "GET",
		PathPattern:        "/org/users/lookup",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetOrgUsersForCurrentOrgLookupReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetOrgUsersForCurrentOrgLookupOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getOrgUsersForCurrentOrgLookup: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RemoveOrgUserForCurrentOrg deletes user in current organization

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `org.users:remove` with scope `users:*`.
*/
func (a *Client) RemoveOrgUserForCurrentOrg(userID int64, opts ...ClientOption) (*RemoveOrgUserForCurrentOrgOK, error) {
	params := NewRemoveOrgUserForCurrentOrgParams().WithUserID(userID)
	return a.RemoveOrgUserForCurrentOrgWithParams(params, opts...)
}

func (a *Client) RemoveOrgUserForCurrentOrgWithParams(params *RemoveOrgUserForCurrentOrgParams, opts ...ClientOption) (*RemoveOrgUserForCurrentOrgOK, error) {
	if params == nil {
		params = NewRemoveOrgUserForCurrentOrgParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "removeOrgUserForCurrentOrg",
		Method:             "DELETE",
		PathPattern:        "/org/users/{user_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &RemoveOrgUserForCurrentOrgReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RemoveOrgUserForCurrentOrgOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for removeOrgUserForCurrentOrg: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateCurrentOrg updates current organization
*/
func (a *Client) UpdateCurrentOrg(body *models.UpdateOrgForm, opts ...ClientOption) (*UpdateCurrentOrgOK, error) {
	params := NewUpdateCurrentOrgParams().WithBody(body)
	return a.UpdateCurrentOrgWithParams(params, opts...)
}

func (a *Client) UpdateCurrentOrgWithParams(params *UpdateCurrentOrgParams, opts ...ClientOption) (*UpdateCurrentOrgOK, error) {
	if params == nil {
		params = NewUpdateCurrentOrgParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateCurrentOrg",
		Method:             "PUT",
		PathPattern:        "/org",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateCurrentOrgReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateCurrentOrgOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateCurrentOrg: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateCurrentOrgAddress updates current organization s address
*/
func (a *Client) UpdateCurrentOrgAddress(body *models.UpdateOrgAddressForm, opts ...ClientOption) (*UpdateCurrentOrgAddressOK, error) {
	params := NewUpdateCurrentOrgAddressParams().WithBody(body)
	return a.UpdateCurrentOrgAddressWithParams(params, opts...)
}

func (a *Client) UpdateCurrentOrgAddressWithParams(params *UpdateCurrentOrgAddressParams, opts ...ClientOption) (*UpdateCurrentOrgAddressOK, error) {
	if params == nil {
		params = NewUpdateCurrentOrgAddressParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateCurrentOrgAddress",
		Method:             "PUT",
		PathPattern:        "/org/address",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateCurrentOrgAddressReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateCurrentOrgAddressOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateCurrentOrgAddress: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateOrgUserForCurrentOrg updates the given user

If you are running Grafana Enterprise and have Fine-grained access control enabled
you need to have a permission with action: `org.users.role:update` with scope `users:*`.
*/
func (a *Client) UpdateOrgUserForCurrentOrg(userID int64, body *models.UpdateOrgUserCommand, opts ...ClientOption) (*UpdateOrgUserForCurrentOrgOK, error) {
	params := NewUpdateOrgUserForCurrentOrgParams().WithBody(body).WithUserID(userID)
	return a.UpdateOrgUserForCurrentOrgWithParams(params, opts...)
}

func (a *Client) UpdateOrgUserForCurrentOrgWithParams(params *UpdateOrgUserForCurrentOrgParams, opts ...ClientOption) (*UpdateOrgUserForCurrentOrgOK, error) {
	if params == nil {
		params = NewUpdateOrgUserForCurrentOrgParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateOrgUserForCurrentOrg",
		Method:             "PATCH",
		PathPattern:        "/org/users/{user_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateOrgUserForCurrentOrgReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateOrgUserForCurrentOrgOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateOrgUserForCurrentOrg: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
