package crypt

var permuteTableMD5Crypt = [16]byte{
	12, 6, 0,
	13, 7, 1,
	14, 8, 2,
	15, 9, 3,
	5, 10, 4,
	11,
}

var permuteTableSHA1Crypt = [21]byte{
	2, 1, 0,
	5, 4, 3,
	8, 7, 6,
	11, 10, 9,
	14, 13, 12,
	17, 16, 15,
	0, 19, 18,
}

var permuteTableSHACryptSHA256 = [32]byte{
	20, 10, 0,
	11, 1, 21,
	2, 22, 12,
	23, 13, 3,
	14, 4, 24,
	5, 25, 15,
	26, 16, 6,
	17, 7, 27,
	8, 28, 18,
	29, 19, 9,
	30, 31,
}

var permuteTableSHACryptSHA512 = [64]byte{
	42, 21, 0,
	1, 43, 22,
	23, 2, 44,
	45, 24, 3,
	4, 46, 25,
	26, 5, 47,
	48, 27, 6,
	7, 49, 28,
	29, 8, 50,
	51, 30, 9,
	10, 52, 31,
	32, 11, 53,
	54, 33, 12,
	13, 55, 34,
	35, 14, 56,
	57, 36, 15,
	16, 58, 37,
	38, 17, 59,
	60, 39, 18,
	19, 61, 40,
	41, 20, 62,
	63,
}

// The following is the 1517 bytes of Hamlet III.ii which is public domain. This is used by Sun's MD5 Crypt function.
var magicTableMD5CryptSunHamlet = [1517]byte{
	84, 111, 32, 98, 101, 44, 32, 111, 114, 32, 110,
	111, 116, 32, 116, 111, 32, 98, 101, 44, 45,
	45, 116, 104, 97, 116, 32, 105, 115, 32, 116,
	104, 101, 32, 113, 117, 101, 115, 116, 105, 111,
	110, 58, 45, 45, 10, 87, 104, 101, 116, 104,
	101, 114, 32, 39, 116, 105, 115, 32, 110, 111,
	98, 108, 101, 114, 32, 105, 110, 32, 116, 104,
	101, 32, 109, 105, 110, 100, 32, 116, 111, 32,
	115, 117, 102, 102, 101, 114, 10, 84, 104, 101,
	32, 115, 108, 105, 110, 103, 115, 32, 97, 110,
	100, 32, 97, 114, 114, 111, 119, 115, 32, 111,
	102, 32, 111, 117, 116, 114, 97, 103, 101, 111,
	117, 115, 32, 102, 111, 114, 116, 117, 110, 101,
	10, 79, 114, 32, 116, 111, 32, 116, 97, 107,
	101, 32, 97, 114, 109, 115, 32, 97, 103, 97,
	105, 110, 115, 116, 32, 97, 32, 115, 101, 97,
	32, 111, 102, 32, 116, 114, 111, 117, 98, 108,
	101, 115, 44, 10, 65, 110, 100, 32, 98, 121,
	32, 111, 112, 112, 111, 115, 105, 110, 103, 32,
	101, 110, 100, 32, 116, 104, 101, 109, 63, 45,
	45, 84, 111, 32, 100, 105, 101, 44, 45, 45,
	116, 111, 32, 115, 108, 101, 101, 112, 44, 45,
	45, 10, 78, 111, 32, 109, 111, 114, 101, 59,
	32, 97, 110, 100, 32, 98, 121, 32, 97, 32,
	115, 108, 101, 101, 112, 32, 116, 111, 32, 115,
	97, 121, 32, 119, 101, 32, 101, 110, 100, 10,
	84, 104, 101, 32, 104, 101, 97, 114, 116, 97,
	99, 104, 101, 44, 32, 97, 110, 100, 32, 116,
	104, 101, 32, 116, 104, 111, 117, 115, 97, 110,
	100, 32, 110, 97, 116, 117, 114, 97, 108, 32,
	115, 104, 111, 99, 107, 115, 10, 84, 104, 97,
	116, 32, 102, 108, 101, 115, 104, 32, 105, 115,
	32, 104, 101, 105, 114, 32, 116, 111, 44, 45,
	45, 39, 116, 105, 115, 32, 97, 32, 99, 111,
	110, 115, 117, 109, 109, 97, 116, 105, 111, 110,
	10, 68, 101, 118, 111, 117, 116, 108, 121, 32,
	116, 111, 32, 98, 101, 32, 119, 105, 115, 104,
	39, 100, 46, 32, 84, 111, 32, 100, 105, 101,
	44, 45, 45, 116, 111, 32, 115, 108, 101, 101,
	112, 59, 45, 45, 10, 84, 111, 32, 115, 108,
	101, 101, 112, 33, 32, 112, 101, 114, 99, 104,
	97, 110, 99, 101, 32, 116, 111, 32, 100, 114,
	101, 97, 109, 58, 45, 45, 97, 121, 44, 32,
	116, 104, 101, 114, 101, 39, 115, 32, 116, 104,
	101, 32, 114, 117, 98, 59, 10, 70, 111, 114,
	32, 105, 110, 32, 116, 104, 97, 116, 32, 115,
	108, 101, 101, 112, 32, 111, 102, 32, 100, 101,
	97, 116, 104, 32, 119, 104, 97, 116, 32, 100,
	114, 101, 97, 109, 115, 32, 109, 97, 121, 32,
	99, 111, 109, 101, 44, 10, 87, 104, 101, 110,
	32, 119, 101, 32, 104, 97, 118, 101, 32, 115,
	104, 117, 102, 102, 108, 101, 100, 32, 111, 102,
	102, 32, 116, 104, 105, 115, 32, 109, 111, 114,
	116, 97, 108, 32, 99, 111, 105, 108, 44, 10,
	77, 117, 115, 116, 32, 103, 105, 118, 101, 32,
	117, 115, 32, 112, 97, 117, 115, 101, 58, 32,
	116, 104, 101, 114, 101, 39, 115, 32, 116, 104,
	101, 32, 114, 101, 115, 112, 101, 99, 116, 10,
	84, 104, 97, 116, 32, 109, 97, 107, 101, 115,
	32, 99, 97, 108, 97, 109, 105, 116, 121, 32,
	111, 102, 32, 115, 111, 32, 108, 111, 110, 103,
	32, 108, 105, 102, 101, 59, 10, 70, 111, 114,
	32, 119, 104, 111, 32, 119, 111, 117, 108, 100,
	32, 98, 101, 97, 114, 32, 116, 104, 101, 32,
	119, 104, 105, 112, 115, 32, 97, 110, 100, 32,
	115, 99, 111, 114, 110, 115, 32, 111, 102, 32,
	116, 105, 109, 101, 44, 10, 84, 104, 101, 32,
	111, 112, 112, 114, 101, 115, 115, 111, 114, 39,
	115, 32, 119, 114, 111, 110, 103, 44, 32, 116,
	104, 101, 32, 112, 114, 111, 117, 100, 32, 109,
	97, 110, 39, 115, 32, 99, 111, 110, 116, 117,
	109, 101, 108, 121, 44, 10, 84, 104, 101, 32,
	112, 97, 110, 103, 115, 32, 111, 102, 32, 100,
	101, 115, 112, 105, 115, 39, 100, 32, 108, 111,
	118, 101, 44, 32, 116, 104, 101, 32, 108, 97,
	119, 39, 115, 32, 100, 101, 108, 97, 121, 44,
	10, 84, 104, 101, 32, 105, 110, 115, 111, 108,
	101, 110, 99, 101, 32, 111, 102, 32, 111, 102,
	102, 105, 99, 101, 44, 32, 97, 110, 100, 32,
	116, 104, 101, 32, 115, 112, 117, 114, 110, 115,
	10, 84, 104, 97, 116, 32, 112, 97, 116, 105,
	101, 110, 116, 32, 109, 101, 114, 105, 116, 32,
	111, 102, 32, 116, 104, 101, 32, 117, 110, 119,
	111, 114, 116, 104, 121, 32, 116, 97, 107, 101,
	115, 44, 10, 87, 104, 101, 110, 32, 104, 101,
	32, 104, 105, 109, 115, 101, 108, 102, 32, 109,
	105, 103, 104, 116, 32, 104, 105, 115, 32, 113,
	117, 105, 101, 116, 117, 115, 32, 109, 97, 107,
	101, 10, 87, 105, 116, 104, 32, 97, 32, 98,
	97, 114, 101, 32, 98, 111, 100, 107, 105, 110,
	63, 32, 119, 104, 111, 32, 119, 111, 117, 108,
	100, 32, 116, 104, 101, 115, 101, 32, 102, 97,
	114, 100, 101, 108, 115, 32, 98, 101, 97, 114,
	44, 10, 84, 111, 32, 103, 114, 117, 110, 116,
	32, 97, 110, 100, 32, 115, 119, 101, 97, 116,
	32, 117, 110, 100, 101, 114, 32, 97, 32, 119,
	101, 97, 114, 121, 32, 108, 105, 102, 101, 44,
	10, 66, 117, 116, 32, 116, 104, 97, 116, 32,
	116, 104, 101, 32, 100, 114, 101, 97, 100, 32,
	111, 102, 32, 115, 111, 109, 101, 116, 104, 105,
	110, 103, 32, 97, 102, 116, 101, 114, 32, 100,
	101, 97, 116, 104, 44, 45, 45, 10, 84, 104,
	101, 32, 117, 110, 100, 105, 115, 99, 111, 118,
	101, 114, 39, 100, 32, 99, 111, 117, 110, 116,
	114, 121, 44, 32, 102, 114, 111, 109, 32, 119,
	104, 111, 115, 101, 32, 98, 111, 117, 114, 110,
	10, 78, 111, 32, 116, 114, 97, 118, 101, 108,
	108, 101, 114, 32, 114, 101, 116, 117, 114, 110,
	115, 44, 45, 45, 112, 117, 122, 122, 108, 101,
	115, 32, 116, 104, 101, 32, 119, 105, 108, 108,
	44, 10, 65, 110, 100, 32, 109, 97, 107, 101,
	115, 32, 117, 115, 32, 114, 97, 116, 104, 101,
	114, 32, 98, 101, 97, 114, 32, 116, 104, 111,
	115, 101, 32, 105, 108, 108, 115, 32, 119, 101,
	32, 104, 97, 118, 101, 10, 84, 104, 97, 110,
	32, 102, 108, 121, 32, 116, 111, 32, 111, 116,
	104, 101, 114, 115, 32, 116, 104, 97, 116, 32,
	119, 101, 32, 107, 110, 111, 119, 32, 110, 111,
	116, 32, 111, 102, 63, 10, 84, 104, 117, 115,
	32, 99, 111, 110, 115, 99, 105, 101, 110, 99,
	101, 32, 100, 111, 101, 115, 32, 109, 97, 107,
	101, 32, 99, 111, 119, 97, 114, 100, 115, 32,
	111, 102, 32, 117, 115, 32, 97, 108, 108, 59,
	10, 65, 110, 100, 32, 116, 104, 117, 115, 32,
	116, 104, 101, 32, 110, 97, 116, 105, 118, 101,
	32, 104, 117, 101, 32, 111, 102, 32, 114, 101,
	115, 111, 108, 117, 116, 105, 111, 110, 10, 73,
	115, 32, 115, 105, 99, 107, 108, 105, 101, 100,
	32, 111, 39, 101, 114, 32, 119, 105, 116, 104,
	32, 116, 104, 101, 32, 112, 97, 108, 101, 32,
	99, 97, 115, 116, 32, 111, 102, 32, 116, 104,
	111, 117, 103, 104, 116, 59, 10, 65, 110, 100,
	32, 101, 110, 116, 101, 114, 112, 114, 105, 115,
	101, 115, 32, 111, 102, 32, 103, 114, 101, 97,
	116, 32, 112, 105, 116, 104, 32, 97, 110, 100,
	32, 109, 111, 109, 101, 110, 116, 44, 10, 87,
	105, 116, 104, 32, 116, 104, 105, 115, 32, 114,
	101, 103, 97, 114, 100, 44, 32, 116, 104, 101,
	105, 114, 32, 99, 117, 114, 114, 101, 110, 116,
	115, 32, 116, 117, 114, 110, 32, 97, 119, 114,
	121, 44, 10, 65, 110, 100, 32, 108, 111, 115,
	101, 32, 116, 104, 101, 32, 110, 97, 109, 101,
	32, 111, 102, 32, 97, 99, 116, 105, 111, 110,
	46, 45, 45, 83, 111, 102, 116, 32, 121, 111,
	117, 32, 110, 111, 119, 33, 10, 84, 104, 101,
	32, 102, 97, 105, 114, 32, 79, 112, 104, 101,
	108, 105, 97, 33, 45, 45, 78, 121, 109, 112,
	104, 44, 32, 105, 110, 32, 116, 104, 121, 32,
	111, 114, 105, 115, 111, 110, 115, 10, 66, 101,
	32, 97, 108, 108, 32, 109, 121, 32, 115, 105,
	110, 115, 32, 114, 101, 109, 101, 109, 98, 101,
	114, 39, 100, 46, 10, 0,
}

var (
	prefixMD5Crypt          = []byte("$1$")
	prefixSHA1Crypt         = []byte("$sha1$")
	prefixSunMD5Crypt       = []byte("$md5$")
	prefixSunMD5CryptRounds = []byte("$md5,rounds=")
	sepCrypt                = []byte("$")
)
