// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"encoding/json"
	"fmt"
	"github.com/censys/censys-sdk-go/internal/utils"
	"github.com/censys/censys-sdk-go/models/components"
	"time"
)

type V3CollectionsListEventsGlobals struct {
	OrganizationID *string `queryParam:"style=form,explode=true,name=organization_id"`
}

func (o *V3CollectionsListEventsGlobals) GetOrganizationID() *string {
	if o == nil {
		return nil
	}
	return o.OrganizationID
}

type ChangeTypes string

const (
	ChangeTypesAsset  ChangeTypes = "asset"
	ChangeTypesStatus ChangeTypes = "status"
)

func (e ChangeTypes) ToPointer() *ChangeTypes {
	return &e
}
func (e *ChangeTypes) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "asset":
		fallthrough
	case "status":
		*e = ChangeTypes(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ChangeTypes: %v", v)
	}
}

type AssetChangeTypes string

const (
	AssetChangeTypesAdded   AssetChangeTypes = "added"
	AssetChangeTypesRemoved AssetChangeTypes = "removed"
)

func (e AssetChangeTypes) ToPointer() *AssetChangeTypes {
	return &e
}
func (e *AssetChangeTypes) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "added":
		fallthrough
	case "removed":
		*e = AssetChangeTypes(v)
		return nil
	default:
		return fmt.Errorf("invalid value for AssetChangeTypes: %v", v)
	}
}

type StatusChangeTypes string

const (
	StatusChangeTypesActive     StatusChangeTypes = "active"
	StatusChangeTypesArchived   StatusChangeTypes = "archived"
	StatusChangeTypesPaused     StatusChangeTypes = "paused"
	StatusChangeTypesPopulating StatusChangeTypes = "populating"
)

func (e StatusChangeTypes) ToPointer() *StatusChangeTypes {
	return &e
}
func (e *StatusChangeTypes) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "active":
		fallthrough
	case "archived":
		fallthrough
	case "paused":
		fallthrough
	case "populating":
		*e = StatusChangeTypes(v)
		return nil
	default:
		return fmt.Errorf("invalid value for StatusChangeTypes: %v", v)
	}
}

type V3CollectionsListEventsRequest struct {
	// The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information.
	OrganizationID *string `queryParam:"style=form,explode=false,name=organization_id"`
	// The UID for the collection. Obtain the collection ID using the [list collections endpoint](https://docs.censys.com/reference/v3-collections-crud-list#/) or via the collection URL when using the web console.
	CollectionUID string `pathParam:"style=simple,explode=false,name=collection_uid"`
	// Amount of results to return per page.
	PageSize *int `queryParam:"style=form,explode=false,name=page_size"`
	// Page token for the requested page of collection results.
	PageToken *string `queryParam:"style=form,explode=false,name=page_token"`
	// Change types
	ChangeTypes []ChangeTypes `queryParam:"style=form,explode=false,name=change_types"`
	// Asset change types
	AssetChangeTypes []AssetChangeTypes `queryParam:"style=form,explode=false,name=asset_change_types"`
	// Status change types
	StatusChangeTypes []StatusChangeTypes `queryParam:"style=form,explode=false,name=status_change_types"`
	// Start time of the host timeline
	StartTime *time.Time `queryParam:"style=form,explode=false,name=start_time"`
	// End time of the host timeline
	EndTime *time.Time `queryParam:"style=form,explode=false,name=end_time"`
}

func (v V3CollectionsListEventsRequest) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V3CollectionsListEventsRequest) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V3CollectionsListEventsRequest) GetOrganizationID() *string {
	if o == nil {
		return nil
	}
	return o.OrganizationID
}

func (o *V3CollectionsListEventsRequest) GetCollectionUID() string {
	if o == nil {
		return ""
	}
	return o.CollectionUID
}

func (o *V3CollectionsListEventsRequest) GetPageSize() *int {
	if o == nil {
		return nil
	}
	return o.PageSize
}

func (o *V3CollectionsListEventsRequest) GetPageToken() *string {
	if o == nil {
		return nil
	}
	return o.PageToken
}

func (o *V3CollectionsListEventsRequest) GetChangeTypes() []ChangeTypes {
	if o == nil {
		return nil
	}
	return o.ChangeTypes
}

func (o *V3CollectionsListEventsRequest) GetAssetChangeTypes() []AssetChangeTypes {
	if o == nil {
		return nil
	}
	return o.AssetChangeTypes
}

func (o *V3CollectionsListEventsRequest) GetStatusChangeTypes() []StatusChangeTypes {
	if o == nil {
		return nil
	}
	return o.StatusChangeTypes
}

func (o *V3CollectionsListEventsRequest) GetStartTime() *time.Time {
	if o == nil {
		return nil
	}
	return o.StartTime
}

func (o *V3CollectionsListEventsRequest) GetEndTime() *time.Time {
	if o == nil {
		return nil
	}
	return o.EndTime
}

type V3CollectionsListEventsResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	ResponseEnvelopeCollectionEventsResponse *components.ResponseEnvelopeCollectionEventsResponse
	Headers                                  map[string][]string
}

func (o *V3CollectionsListEventsResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V3CollectionsListEventsResponse) GetResponseEnvelopeCollectionEventsResponse() *components.ResponseEnvelopeCollectionEventsResponse {
	if o == nil {
		return nil
	}
	return o.ResponseEnvelopeCollectionEventsResponse
}

func (o *V3CollectionsListEventsResponse) GetHeaders() map[string][]string {
	if o == nil {
		return map[string][]string{}
	}
	return o.Headers
}
