// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"errors"
	"fmt"
	"github.com/censys/censys-sdk-go/internal/utils"
)

type TargetWebOrigin struct {
	// Hostname of the web origin
	Hostname string `json:"hostname"`
	// Port number of the web origin
	Port int `json:"port"`
}

func (o *TargetWebOrigin) GetHostname() string {
	if o == nil {
		return ""
	}
	return o.Hostname
}

func (o *TargetWebOrigin) GetPort() int {
	if o == nil {
		return 0
	}
	return o.Port
}

// Two - Rescan of known web property
type Two struct {
	WebOrigin TargetWebOrigin `json:"web_origin"`
}

func (o *Two) GetWebOrigin() TargetWebOrigin {
	if o == nil {
		return TargetWebOrigin{}
	}
	return o.WebOrigin
}

type TargetTransportProtocol string

const (
	TargetTransportProtocolUnknown TargetTransportProtocol = "unknown"
	TargetTransportProtocolTCP     TargetTransportProtocol = "tcp"
	TargetTransportProtocolUDP     TargetTransportProtocol = "udp"
	TargetTransportProtocolIcmp    TargetTransportProtocol = "icmp"
	TargetTransportProtocolQuic    TargetTransportProtocol = "quic"
)

func (e TargetTransportProtocol) ToPointer() *TargetTransportProtocol {
	return &e
}
func (e *TargetTransportProtocol) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "unknown":
		fallthrough
	case "tcp":
		fallthrough
	case "udp":
		fallthrough
	case "icmp":
		fallthrough
	case "quic":
		*e = TargetTransportProtocol(v)
		return nil
	default:
		return fmt.Errorf("invalid value for TargetTransportProtocol: %v", v)
	}
}

type TargetServiceID struct {
	// IP address of service
	IP string `json:"ip"`
	// Port number of service
	Port int `json:"port"`
	// Name of service protocol
	Protocol          string                  `json:"protocol"`
	TransportProtocol TargetTransportProtocol `json:"transport_protocol"`
}

func (o *TargetServiceID) GetIP() string {
	if o == nil {
		return ""
	}
	return o.IP
}

func (o *TargetServiceID) GetPort() int {
	if o == nil {
		return 0
	}
	return o.Port
}

func (o *TargetServiceID) GetProtocol() string {
	if o == nil {
		return ""
	}
	return o.Protocol
}

func (o *TargetServiceID) GetTransportProtocol() TargetTransportProtocol {
	if o == nil {
		return TargetTransportProtocol("")
	}
	return o.TransportProtocol
}

// One - Rescan of known service
type One struct {
	ServiceID TargetServiceID `json:"service_id"`
}

func (o *One) GetServiceID() TargetServiceID {
	if o == nil {
		return TargetServiceID{}
	}
	return o.ServiceID
}

type ScansRescanInputBodyTargetType string

const (
	ScansRescanInputBodyTargetTypeOne ScansRescanInputBodyTargetType = "1"
	ScansRescanInputBodyTargetTypeTwo ScansRescanInputBodyTargetType = "2"
)

type ScansRescanInputBodyTarget struct {
	One *One `queryParam:"inline"`
	Two *Two `queryParam:"inline"`

	Type ScansRescanInputBodyTargetType
}

func CreateScansRescanInputBodyTargetOne(one One) ScansRescanInputBodyTarget {
	typ := ScansRescanInputBodyTargetTypeOne

	return ScansRescanInputBodyTarget{
		One:  &one,
		Type: typ,
	}
}

func CreateScansRescanInputBodyTargetTwo(two Two) ScansRescanInputBodyTarget {
	typ := ScansRescanInputBodyTargetTypeTwo

	return ScansRescanInputBodyTarget{
		Two:  &two,
		Type: typ,
	}
}

func (u *ScansRescanInputBodyTarget) UnmarshalJSON(data []byte) error {

	var one One = One{}
	if err := utils.UnmarshalJSON(data, &one, "", true, true); err == nil {
		u.One = &one
		u.Type = ScansRescanInputBodyTargetTypeOne
		return nil
	}

	var two Two = Two{}
	if err := utils.UnmarshalJSON(data, &two, "", true, true); err == nil {
		u.Two = &two
		u.Type = ScansRescanInputBodyTargetTypeTwo
		return nil
	}

	return fmt.Errorf("could not unmarshal `%s` into any supported union types for ScansRescanInputBodyTarget", string(data))
}

func (u ScansRescanInputBodyTarget) MarshalJSON() ([]byte, error) {
	if u.One != nil {
		return utils.MarshalJSON(u.One, "", true)
	}

	if u.Two != nil {
		return utils.MarshalJSON(u.Two, "", true)
	}

	return nil, errors.New("could not marshal union type ScansRescanInputBodyTarget: all fields are null")
}

type ScansRescanInputBody struct {
	Target ScansRescanInputBodyTarget `json:"target"`
}

func (o *ScansRescanInputBody) GetTarget() ScansRescanInputBodyTarget {
	if o == nil {
		return ScansRescanInputBodyTarget{}
	}
	return o.Target
}
