/* log.c
 * geg, a GTK+ Equation Grapher
 * David Bryant 1998
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <string.h>
#include "log.h"

/* locally global data */
static GtkWidget *log_te;

/* create_log, create the log
 */
void
create_log(GtkWidget *widget)
{
  GtkWidget *hb, *sb;

  hb = gtk_hbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(widget), hb);
  gtk_widget_show(hb);

  log_te = gtk_text_new(NULL, NULL);
  gtk_box_pack_start(GTK_BOX(hb), log_te, TRUE, TRUE, 0);
  gtk_widget_show(log_te);

  sb = gtk_vscrollbar_new(GTK_TEXT(log_te)->vadj);
  gtk_box_pack_start(GTK_BOX(hb), sb, FALSE, FALSE, 0);

  gtk_widget_show(sb);
}

/* write_log, write a message to the log
 */
void
write_log(GtkWidget *widget, gchar *message)
{
  gtk_text_freeze(GTK_TEXT(log_te));
  gtk_text_insert(GTK_TEXT(log_te), NULL, NULL, NULL, message, strlen(message));
  gtk_text_insert(GTK_TEXT(log_te), NULL, NULL, NULL, "\n", 1);
  gtk_text_set_point(GTK_TEXT(log_te), 0);

  gtk_text_thaw(GTK_TEXT(log_te));
}

/* clear_log, clear the text in the log
 */
void
clear_log(GtkWidget *widget, gpointer data)
{
  gtk_text_freeze(GTK_TEXT(log_te));
  gtk_editable_delete_text(GTK_EDITABLE(log_te), 0, -1);
  gtk_text_thaw(GTK_TEXT(log_te));
}
