# CSV Special Characters
- [Python CSV documentation](https://docs.python.org/3/library/csv.html#dialects-and-formatting-parameters)

## Python variables that control CSV file reading/writing:
```
Dialect.delimiter
    A one-character string used to separate fields.
    It defaults to ','.

Dialect.doublequote
    Controls how instances of quotechar appearing inside a field should themselves be quoted.
    When True, the character is doubled. When False, the escapechar is used as a prefix to the quotechar.
    It defaults to True.

Dialect.escapechar
    A one-character string used by the writer to escape the delimiter if quoting is set to QUOTE_NONE and the quotechar if doublequote is False.
    On reading, the escapechar removes any special meaning from the following character.
    It defaults to None, which disables escaping.

Dialect.lineterminator
    The string used to terminate lines produced by the writer.
    It defaults to '\r\n'.

    The reader is hard-coded to recognise either '\r' or '\n' as end-of-line, and ignores lineterminator.

Dialect.quotechar
    A one-character string used to quote fields containing special characters, such as the delimiter or quotechar, or which contain new-line characters.
    It defaults to '"'.

Dialect.quoting
    Controls when quotes should be generated by the writer and recognised by the reader. It can take on any of the QUOTE_* constants (see section Module Contents).
    It defaults to QUOTE_MINIMAL.
```

## GAM variables that control CSV file reading/writing:
```
csv_input_column_delimiter = , - Dialect.delimiter
csv_input_no_escape_char = true - Dialect.escapechar is set to None if true, '\' if false
csv_input_quote_char = " - Dialect.quotechar
csv_output_column_delimiter = , - Dialect.delimiter
csv_output_no_escape_char = false - Dialect.escapechar is set to None if true, '\' if false
csv_output_line_terminator = lf - Dialect.lineterminator
csv_output_quote_char = " - Dialect.quotechar
todrive_no_escape_char = true - Dialect.escapechar is set to None if true, '\' if false
```

GAM sets Dialect.doublequote to true and Dialect.quoting to QUOTE_MINIMAL; there are no variables to change these values.

## Examples

### Local file, default settings
With these settings, here are examples of how field values are mapped on output to a local file:
```
csv_output_column_delimiter = ,
csv_output_no_escape_char = false
csv_output_quote_char = "
```

| Input | Output |
|-------|--------|
| abc def | abc def |
| abc,def | "abc,def" |
| abc"def | "abc""def" |
| abc\def | abc\\\\def |

### Local file, modified settings
With these settings, here are examples of how field values are mapped on output to a local file:
```
csv_output_column_delimiter = ,
csv_output_no_escape_char = true
csv_output_quote_char = "
```

| Input | Output |
|-------|--------|
| abc def | abc def |
| abc,def | "abc,def" |
| abc"def | "abc""def" |
| abc\def | abc\def |

### todrive, default settings
With these settings, here are examples of how field values are mapped on output to todrive
```
csv_output_column_delimiter = ,
todrive_no_escape_char = true
csv_output_quote_char = "
```

| Input | Output |
|-------|--------|
| abc def | abc def |
| abc,def | "abc,def" |
| abc"def | "abc""def" |
| abc\def | abc\def |
