
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


/* Implement the SHAPE intrinsic as well as the array versions of
 * LBOUND and UBOUND as well as SHAPE.  The scalar versions are
 * translated inline. */

#include "runtime.h"

enum { LBOUND, UBOUND, SHAPE } ;


/* shape()-- Work function for SHAPE, UBOUND and LBOUND */

static g95_array_descriptor *shape4(g95_array_descriptor *array,
				    int operation) {
g95_array_descriptor *desc;
G95_INT4 *ip;
int i;

    if (array->base == NULL)
	switch(operation) {
	case LBOUND:
	    runtime_error("Deallocated array passed to LBOUND");

	case UBOUND:
	    runtime_error("Deallocated array passed to UBOUND");

	case SHAPE:
	    runtime_error("Deallocated array passed to SHAPE");
	}

    desc = temp_array(1, sizeof(G95_INT4), (G95_AINT) array->rank);
    ip = (G95_INT4 *) desc->base;

    for(i=0; i<array->rank; i++) {
	switch(operation) {
	case LBOUND:
	    *ip++ = array->info[i].lbound;
	    break;

	case UBOUND:
	    *ip++ = array->info[i].ubound;
	    break;

	case SHAPE:
	    *ip++ = (array->info[i].lbound > array->info[i].ubound) ? 0 : 
		    (array->info[i].ubound - array->info[i].lbound + 1);
	    break;
	}
    }

    return desc;
}




/* lbound()-- LBOUND intrinsic */

#define lbound_4 prefix(lbound_4)

g95_array_descriptor *lbound_4(g95_array_descriptor *desc) {

    return shape4(desc, LBOUND);
}


/* ubound()-- UBOUND intrinsic */

#define ubound_4 prefix(ubound_4)

g95_array_descriptor *ubound_4(g95_array_descriptor *desc) {

    return shape4(desc, UBOUND);
}



/* shape()-- SHAPE intrinsic */

#define shape_4 prefix(shape_4)

g95_array_descriptor *shape_4(g95_array_descriptor *desc) {

    return shape4(desc, SHAPE);
}




static g95_array_descriptor *shape8(g95_array_descriptor *array,
				    int operation) {
g95_array_descriptor *desc;
G95_INT8 *ip;
int i;

    if (array->base == NULL)
	switch(operation) {
	case LBOUND:
	    runtime_error("Deallocated array passed to LBOUND");

	case UBOUND:
	    runtime_error("Deallocated array passed to UBOUND");

	case SHAPE:
	    runtime_error("Deallocated array passed to SHAPE");
	}

    desc = temp_array(1, sizeof(G95_INT8), (G95_AINT) array->rank);
    ip = (G95_INT8 *) desc->base;

    for(i=0; i<array->rank; i++) {
	switch(operation) {
	case LBOUND:
	    *ip++ = array->info[i].lbound;
	    break;

	case UBOUND:
	    *ip++ = array->info[i].ubound;
	    break;

	case SHAPE:
	    *ip++ = (array->info[i].lbound > array->info[i].ubound) ? 0 : 
		    (array->info[i].ubound - array->info[i].lbound + 1);
	    break;
	}
    }

    return desc;
}




/* lbound()-- LBOUND intrinsic */

#define lbound_8 prefix(lbound_8)

g95_array_descriptor *lbound_8(g95_array_descriptor *desc) {

    return shape8(desc, LBOUND);
}


/* ubound()-- UBOUND intrinsic */

#define ubound_8 prefix(ubound_8)

g95_array_descriptor *ubound_8(g95_array_descriptor *desc) {

    return shape8(desc, UBOUND);
}



/* shape()-- SHAPE intrinsic */

#define shape_8 prefix(shape_8)

g95_array_descriptor *shape_8(g95_array_descriptor *desc) {

    return shape8(desc, SHAPE);
}
