
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the MVBITS() intrinsic. */

#include "runtime.h"

#define mvbits prefix(mvbits)

void mvbits(void *from_p,     G95_DINT from_kind,
	    void *frompos_p,  G95_DINT frompos_kind,
	    void *len_p,      G95_DINT len_kind,
	    void *to_p,       G95_DINT to_kind,
	    void *topos_p,    G95_DINT topos_kind) {

unsigned G95_MINT from, to, mask;
int frompos, len, topos;

    from    = extract_mint(from_p,        from_kind);
    frompos = extract_integer(frompos_p,  frompos_kind);
    len     = extract_integer(len_p,      len_kind);
    to      = extract_mint(to_p,          to_kind);
    topos   = extract_integer(topos_p,    topos_kind);

    if (len >= 8*sizeof(G95_MINT))
	mask = ~0;

    else {
	mask = 0;
	mask = ~((~mask) << len);
    }

    to = (to & (~(mask << topos))) |
	(((from & (mask << frompos)) >> frompos) << topos);

    set_mint(to, to_p, to_kind);
}
