
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

 This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <string.h>
#include <stdlib.h>

#include "runtime.h"

#define get_environment_variable prefix(get_environment_variable)

void get_environment_variable(char *name, char *value, G95_DINT *length,
			      G95_DINT *status, G95_DINT *trim_name,
			      G95_DINT name_len, G95_DINT value_len) {

char *p, *q;
int q_len;

    if (trim_name == NULL || (*trim_name))
	while(name_len > 0 && name[name_len-1] == ' ')
	    name_len--;

    p = temp_alloc(name_len+1);
    memmove(p, name, name_len);
    p[name_len] = '\0';

    q = getenv(p);
    q_len = (q == NULL) ? 0 : strlen(q);
    temp_free((void *) &p);

    if (length != NULL) 
	*length = (q == NULL) ? 0 : q_len;

    if (status != NULL) {
	if (q == NULL)
	    *status = 1;

	else if (value != NULL && value_len < q_len)
	    *status = -1;

	else
	    *status = 0;
    }

    if (value != NULL)
	copy_string(value, value_len, q, q_len);
}
