#[[GNUInstallDirs defines CMAKE_INSTALL_{BIN,LIB}DIR and the like, abiding by GNU installation conventions.
   See https://cmake.org/cmake/help/latest/module/GNUInstallDirs.html]]
include(GNUInstallDirs)
# Add an absolute path for the project's CMake config file
set(PROJECT_CMAKEDIR    # see https://cmake.org/cmake/help/latest/command/find_package.html#search-procedure
    ${CMAKE_INSTALL_LIBDIR}/${CMAKE_PROJECT_NAME}/cmake)

# Prepare RPATH
set(CMAKE_SKIP_RPATH FALSE) # define RPATHs both for the build tree (CMAKE_SKIP_BUILD_RPATH=FALSE) and for the install tree (CMAKE_SKIP_INSTALL_RPATH=FALSE)
set(CMAKE_BUILD_WITH_INSTALL_RPATH FALSE) # use install tree RPATH only for install targets
set(CMAKE_BUILD_RPATH_USE_ORIGIN TRUE) # make RPATH entries within build tree (i.e. *not* the install tree) relative, and thus relocatable
list(APPEND CMAKE_INSTALL_RPATH ${CMAKE_INSTALL_PREFIX}/${CMAKE_INSTALL_LIBDIR})
set(CMAKE_INSTALL_RPATH_USE_LINK_PATH TRUE) # any directory external to and used by this project will be added to RPATH