#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/mman.h>

#ifndef MAP_FAILED
#define MAP_FAILED  ((void *)-1)
#endif

char *font_base;

struct romfont {
	int height;
	int width;

	int koffset;
	int kwidth;
	int kbytes;
	int aoffset;
	int awidth;
	int abytes;
	int goffset;
	int gwidth;
	int gbytes;
	int fd;	/* external font */
} font;

struct romfont *f = NULL;

int load_font(char *fname, int width, int height,int mode) {
	char *p;
	int fd,r;
	int fsize;
	char buf[256];
	int ver,w,h;

	f = &font;

	fd = open(fname,mode?2:0);
	if (fd < 0) {
		printf(" -- error : can't open\n");
		return -1;
	}
	r = read(fd,buf,256);
	if (r != 256) {
		printf(" -- error : can't read\n");
		close(fd);
		return -1;
	}
	fsize = lseek(fd,0L,SEEK_END);
	lseek(fd,0L,SEEK_SET);

	if (sscanf(buf,"#MGLFONT%02d%02d%02d",&ver,&w,&h) == 3) {
		width = w;
		height = h;
	} else {
		if ((width <= 0) || (height <= 0)) {
			printf("-- error : no magic\n");
			close(fd);
			return (-1);
		}
		printf("-- warning : no magic\n");
	}

	f->height = height;
	f->width = width;
	f->aoffset = 32;
	f->awidth = (width/2+7)/8;
	f->abytes = f->awidth * height;
	f->koffset = f->aoffset + f->abytes * 256;
	f->kwidth = (width+7)/8;
	f->kbytes = f->kwidth * height;
	f->fd = fd;
	if (fsize != f->koffset + f->kbytes*8064) {
		printf(" -- error : not mgl font file(filesize not match)\n");
		close(fd);
		return -1;
	}
	font_base = (char *) mmap((caddr_t)0, f->koffset + f->kbytes*8064,
				   PROT_READ | (mode?PROT_WRITE:0),
				   MAP_SHARED | MAP_FILE,
				   fd, 0);
	if (font_base == MAP_FAILED) {
		printf(" -- can't mmap\n");
		close(fd);
		return -1;
	}
	if (mode) {
		sprintf(font_base,"#MGLFONT%02d%02d%02d",1,width,height);
	}
	return fd;
}

main(argc,argv) int argc; char *argv[]; {
	int c;
	char *fname;
	char *mes = 0;
	int width = -1;
	int height= -1;
	int tmp;
	int ank_dump = -1;
	int kanji_dump = -1;
	int patch_flag = 0;

	while ((c=getopt(argc,argv,"w:h:s:AKa:k:p")) != -1) {
	    switch (c) {
	    case 'h':
		if (sscanf(optarg,"%d",&tmp) == 1) height = tmp;
		break;
	    case 'w':
		if (sscanf(optarg,"%d",&tmp) == 1) width = tmp;
		break;
	    case 's':
		mes = optarg;
		break;
	    case 'A':
		ank_dump = -2;
		break;
	    case 'K':
		kanji_dump = -2;
		break;
	    case 'a':
		if (sscanf(optarg,"%d",&tmp) == 1) ank_dump = tmp;
		break;
	    case 'k':
		if (sscanf(optarg,"%d",&tmp) == 1) kanji_dump = tmp;
		break;
	    case 'p':
		patch_flag = 1;
		break;
	    }
	}
	if (optind == argc) {
		printf("usage:\n");
		printf("show info:\n");
		printf("  mgl_fontinfo [-w width] [-h height] [-A] [-K] [-a code] [-k code] fname [fname..]\n");
		printf("  -A      -- dump all ank font\n");
		printf("  -K      -- dump all kanji font\n");
		printf("  -a code -- dump ank font\n");
		printf("  -k code -- dump kanji font\n");
		printf("set info:\n");
		printf("  mgl_fontinfo [-w width] [-h height] -s info fname [fname..]\n");
		printf("patch font:\n");
		printf("  mgl_fontinfo [-w width] [-h height] -p fname < patch_data\n");
		printf("   patch_data : dumped font data with dump option\n");
		printf("note: if magic is not set use -w and -h \n");
		exit(0);
	}
	while (optind < argc) {
	    printf("%s:\n",argv[optind]);
	    if (load_font(argv[optind],width,height,(mes||patch_flag)?1:0)>=0) {
		if (mes) {
		    if (strlen(mes) >= 64* font.kbytes) {
		        printf("--- message is too long\n");
		        mes = 0;
		    } else {
		        strcpy(font_base + font.koffset + font.kbytes*8000
				,mes);
		    }
		}
		printf("%s\n", font_base + font.koffset + font.kbytes*8000);
		if (patch_flag) {
			patch_font();
		}
		if (ank_dump != -1) {
			dump_a(ank_dump);
		}
		if (kanji_dump != -1) {
			dump_k(kanji_dump);
		}
		munmap(font_base,font.koffset + font.kbytes*8064);
		close(font.fd);
	    }
		optind ++;
	}
}

dump_a(int code) {
	int i,j,k;
	int c;
	printf("height %d\n",f->height);
	printf("width %d\n",f->width);

	for (i=0; i<256; i++) {
		if ((code >= 0) && (code != i))
			continue;
		printf("--- ank[%d]\n",i);
		for (j=0; j< f->height; j++) {
			for (k=0; k < f->width/2; k++) {
				c = font_base[ f->aoffset + f->abytes * i +
					f->awidth * j + (k / 8)];
				if ( c & (1 << (7- (k%8)))) {
					printf("X");
				} else {
					printf(".");
				}
			}
			printf("\n");
		}
	}
}

dump_k(int code) {
	int i,j,k;
	int c;
	printf("height %d\n",f->height);
	printf("width %d\n",f->width);
	for (i=0; i<8000; i++) {
		if ((code >= 0) && (code != i))
			continue;
		printf("--- kanji[%d]\n",i);
		for (j=0; j< f->height; j++) {
			for (k=0; k < f->width; k++) {
				c = font_base[ f->koffset + f->kbytes * i +
					f->kwidth * j + (k / 8)];
				if ( c & (1 << (7- (k%8)))) {
					printf("X");
				} else {
					printf(".");
				}
			}
			printf("\n");
		}
	}
}

patch_font() {
	char buf[256];
	int st = 0;
	int code = -1;
	int h = -1;
	int tmp;
	char *p;
	int i;

	while (fgets(buf,256,stdin)) {
		if (sscanf(buf,"--- ank[%d]",&tmp) == 1) {
		    if ((tmp >= 0) && (tmp < 256)) {
printf("patching ank[%d]\n",tmp);
			st = 1;
			code = tmp;
			h = 0;
			p = font_base + f->aoffset + f->abytes * code;
		    }
		}
		else if (sscanf(buf,"--- kanji[%d]",&tmp) == 1) {
		    if ((tmp >= 0) && (tmp < 8000)) {
printf("patching kanji[%d]\n",tmp);
			st = 2;
			code = tmp;
			h = 0;
			p = font_base + f->koffset + f->kbytes * code;
		    }
		}
		else if (st == 1) {
			for (i=0; i< f->width/2; i++) {
				if (buf[i] != '.' && buf[i] != 'X') {
printf("patchdata error1 \n");
					break;
				}
			}
			if ((i == f->width/2 ) && (h < f->height)) {
			    for (i=0; i< f->width/2; i++) {
				if (buf[i] == '.') {
					p[i/8] &= ~(1 << (7 - (i%8)));
				} else {
					p[i/8] |= (1 << (7 - (i%8)));
				}
			    }
			    p += f->awidth;
			    h ++;
			} else {
			    st = 0;
			}
		}
		else if (st == 2) {
			for (i=0; i< f->width; i++) {
				if (buf[i] != '.' && buf[i] != 'X') {
printf("patchdata error2 \n");
					break;
				}
			}
			if ((i == f->width ) && (h < f->height)) {
			    for (i=0; i< f->width; i++) {
				if (buf[i] == '.') {
					p[i/8] &= ~(1 << (7 - (i%8)));
				} else {
					p[i/8] |= (1 << (7 - (i%8)));
				}
			    }
			    p += f->kwidth;
			    h ++;
			} else {
			    st = 0;
			}
		}
	}
}
