#ifndef HMAC_H
#define HMAC_H  1


/* ========================================================================== */
/* Include files */


/*! \addtogroup HMAC */
/*! @{ */


/* ========================================================================== */
/* Constants */

/*! \name Lenght of message authentication codes */
/*! @{ */
#define HMAC_SHA1_160_LEN  (size_t) 20  /*!< \brief 160 bit */
#define HMAC_SHA2_256_LEN  (size_t) 32  /*!< \brief 256 bit */
/*! @} */


/*! @} */


/* ========================================================================== */
/* Function prototypes */

int  hmac_sha1_160(const char*, size_t, const char*, size_t,
                          unsigned char*);
int  hmac_sha2_256(const char*, size_t, const char*, size_t,
                          unsigned char*);
void  hmac_init(void);
void  hmac_exit(void);


#endif  /* HMAC_H */

/* EOF */
