#! /bin/sh

# Add "X-No-Archive: yes" header field if "Archive" checkbox of GUI is disabled
#
# Why? Google has not implemented RFC 5536.
#
# awk looks for the header field "Archive: no" (as defined in RFC 5536)
# and prints the nonstandard "X-No-Archive: yes" only if it is present.
# This is done only once and only in the header of the article.

# Abort on error
set -e

# Set locale with UTF-8 encoding for awk
# This filter will be feeded with whole articles (body is always UTF-8 encoded)
#
# The locale name "en_US.UTF-8" must be modified to match an existing locale of
# the system (that uses UTF-8 encoding). Use "locale -a" to list system locales.
export LC_ALL=en_US.UTF-8

# Process article
awk -v i=0 '/^Archive: no\r$/ { print ; if(!i) print "X-No-Archive: yes\r" ; i=1 ; next } /^\r$/ { i=1 } { print }'


# EOF
