/*
  types.h
  
  for Final battle
  
  By Mike Hufnagel and Bill Kendrick
  Previously modified: 12/5/95
  Last modified: 12/4/97

  Holds type definitions.
*/


#ifndef TYPES_H
#define TYPES_H

#include "const.h"


/* Window geometry structure: */

typedef struct Geom {
  int x, y;                     /* Positon */
  int w, h;                     /* Size */
} geom;


/* Player data struct: */

typedef struct Playerdata {
  int exist;                     /* Do I (still) exist? */
  int x, y;                      /* Position */
  int dir;                       /* Facing direction */
  int xm, ym;                    /* Momentum (speed/direction) */
  int max;                       /* This player's max. momentum */
  int weapons[UNIQUE_WEAPONS];   /* Their weapon supply */
  int current_weapon;            /* Their currently selected weapon */
  int armor;                     /* Armor status */
  int shields;                   /* Shields status */
  int cloaked;                   /* Cloaked status */
  int can_radar_cloak;           /* Cloaking ability/count... */
  int can_total_cloak;
  long energy;                   /* Energy status */
  int energylow;                 /* Whether "energy low" message was shown */
  int cloakradar, mineradar;     /* Do they have cloak or mine radar? */
  int homingmode;                /* Homing mode, point and ship... */
  int homex, homey;
  int homeship;
  int warp, home, autop;         /* Point-click radar upgrades */
  int damage[UNIQUE_DAMAGABLES]; /* Damage and crew info... */
  int damagetime[UNIQUE_DAMAGABLES];
  int crew_working[UNIQUE_DAMAGABLES];
  int crew_free;
  int crew_frozen;
  char playermessage[80];        /* Message for action window */
  int playermessage_life;        /* How long til it goes away */
} playerdata;


/* Star position struct: */

typedef struct Stardata {
  int x, y;                      /* Position */
  int color;                     /* Color */
} stardata;


/* Debris data struct: */

typedef struct Debrisdata {
  int exist;                     /* Do I (still) exist? */
  int x, y;                      /* Position */
  int xm, ym;                    /* Momentum (speed/direction) */
  int range;                     /* How long will I last before vanishing? */
  int color;                     /* Cool!  Some colors! */
} debrisdata;


/* Dead man data struct: */

typedef struct Deadmandata {
  int exist;                     /* Do I (still) exist? */
  int x, y;                      /* Position */
  int xm, ym;                    /* Momentum (speed/direction) */
  int range;                     /* How long will I last before vanishing? */
} deadmandata;


/* Asteroid data struct: */

typedef struct Asteroiddata {
  int exist;                     /* Do I (still) exist? */
  int x, y;                      /* Position */
  int xm, ym;                    /* Momentum (speed/direction) */
  int rotation;                  /* Rotation (animation frame) */
  int rotationm;                 /* Rotation change (speed/sign) */
} asteroiddata;


/* Drone data struct: */

typedef struct Dronedata {
  int exist;                     /* Do I (still) exist? */
  int x, y;                      /* Position */
  int xm, ym;                    /* Momentum (speed/direction) */
  int homeship;                  /* Who am I after? */
  int hometime;                  /* How long til I'm finished with them? */
} dronedata;


/* Upgrade data struct: */

typedef struct Upgradedata {
  int exist;                     /* Do I (still) exist? */
  int type;                      /* Which upgrade am I? */
  int weapon_num;                /* In case type is UPGRADE_WEAPON */
  int x, y;                      /* Position */
  int xm, ym;                    /* Momentum (speed/direction) */
  int rotation;                  /* Rotation (animation frame) */
} upgradedata;


/* Weapon data struct: */

typedef struct Weapondata {
  int exist;                     /* Do I (still) exist? */
  int type;                      /* Which weapon am I? */
  int x, y;                      /* Position */
  int xm, ym;                    /* Momentum (speed/direction) */
  int range;                     /* How much farther til I die? (count down) */
  int targetship;                /* Which ship we're targetting (for homing) */
  int targetx, targety;          /* Target ship's position */
} weapondata;


/* Wormhole data struct: */

typedef struct Wormholedata {
  int exist;
  int x, y;
  int xm, ym;
  int warpx, warpy;
  int warpxm, warpym;
  int range;
} wormholedata;

#endif /* TYPES_H */
