/*
  radarwin.c
  
  for Final Battle
  
  Mike Hufnagel & Bill Kendrick
  Last modified: 11/19/95
  Last modified: 12/4/97
*/


#include "const.h"
#include "glovar.h"
#include "radarwin.h"
#include "types.h"


void drawradar(int pln)
{
  int x, y, i, xx, yy;
  
  
  /* Erase window: */
  
  XClearWindow(display[pln],radarwin[pln]);
  
  
  if ((player[pln].damage[DAM_RADAR] == OK) ||
      ((player[pln].damage[DAM_RADAR] == DAMAGED) &&
       (rndm(10) < 5)))
    {
      /* Crosshairs (quadrant seperators) in the radar window */
      
      XDrawLine(display[pln], radarwin[pln], radardashedgc[pln],
		radargeom[pln].w / 2, 0, radargeom[pln].w / 2,
		radargeom[pln].h);
      XDrawLine(display[pln], radarwin[pln], radardashedgc[pln],
		0, radargeom[pln].h / 2, radargeom[pln].w,
		radargeom[pln].h / 2);
      
      
      /* Draw the ships in the radar window */
      
      for (i = 0; i < SERV; i++)
	{
	  if (player[i].exist)
	    {
	      /* Determine the pos'on of the player and "do"
		 the aspect ratio */
	      
	      x = player[i].x / (WIDTH_OF_WORLD / radargeom[pln].w);
	      y = player[i].y / (HEIGHT_OF_WORLD / radargeom[pln].h);
	      
	      /* Fix the x and y so we don't go off the radar */
	      
	      if (x <= 4)
		x = 4;
	      else if (x >= (radargeom[pln].w - 4))
		x = radargeom[pln].w - 4;
	      
	      if (y <= 4)
		y = 4;
	      else if (y >= (radargeom[pln].h - 4))
		y = radargeom[pln].h - 4;
	      
	      
	      if (pln == i)
		{
		  /* You're a large outlined ball unless you're cloaked */
		  
		  XDrawArc(display[pln], radarwin[pln], radargc[pln],
			   x - 4, y - 4, 8, 8, 0, (360 * 64));
		  
		  /* If you're cloaked, then you're a ball with an 'X' */
		  
		  if (player[pln].cloaked != CLOAK_NONE)
		    {
		      XDrawLine(display[pln], radarwin[pln], radargc[pln],
				x - 4, y - 4, x + 4, y + 4);
		      XDrawLine(display[pln], radarwin[pln], radargc[pln],
				x + 4, y - 4, x - 4, y + 4);
		    }
		}
	      else
		{
		  /* Make sure they're not cloaked */
		  
		  if (player[i].cloaked == CLOAK_NONE ||
		      player[pln].cloakradar)
		    {
		      /* They are small blips unless they're cloaked */
		      
		      XFillArc(display[pln], radarwin[pln], radargc[pln],
			       x - 2, y - 2, 4, 4, 0, (360 * 64));
		      
		      /* If they're cloaked, also draw an 'X' through them */
		      
		      if (player[i].cloaked != CLOAK_NONE)
			{
			  XDrawLine(display[pln], radarwin[pln], radargc[pln], 
				    x - 4, y - 4, x + 4, y + 4);
			  XDrawLine(display[pln], radarwin[pln], radargc[pln], 
				    x + 4, y - 4, x - 4, y + 4);
			}
		    }
		}
	    } /* (if player[i].exist) */
	} /* (for SERV) */
      
      
      /* Draw the drones in the radar window */
      
      for (i = 0; i < NUM_DRONES; i++)
	{
	  if (drone[i].exist)
	    {
	      /* Determine the pos'on of the player and "do"
		 the aspect ratio */
	      
	      x = drone[i].x / (WIDTH_OF_WORLD / radargeom[pln].w);
	      y = drone[i].y / (HEIGHT_OF_WORLD / radargeom[pln].h);
	      
	      
	      /* Fix the x and y so we don't go off the radar */
	      
	      if (x <= 4)
		x = 4;
	      else if (x >= (radargeom[pln].w - 4))
		x = radargeom[pln].w - 4;
	      
	      if (y <= 4)
		y = 4;
	      else if (y >= (radargeom[pln].h - 4))
		y = radargeom[pln].h - 4;
	      
	      XDrawPoint(display[pln], radarwin[pln], radargc[pln], x, y);
	      
	    } /* (if drone[i].exist) */
	} /* for NUM_DRONES */
      
      
      /* If you're homing in on some player, draw a box around it! */
      
      if (player[pln].homingmode == HOME_HOMING)
	{
	  x = player[player[pln].homeship].x /
	    (WIDTH_OF_WORLD / radargeom[pln].w);
	  y = player[player[pln].homeship].y /
	    (HEIGHT_OF_WORLD / radargeom[pln].h);
	  XDrawRectangle(display[pln], radarwin[pln], radargc[pln],
			 x - 4, y - 4, 8, 8);
	}
      
      if (player[pln].homingmode == HOME_AUTO)
	{
	  x = player[pln].homex / (WIDTH_OF_WORLD / radargeom[pln].w);
	  y = player[pln].homey / (HEIGHT_OF_WORLD / radargeom[pln].h);
	  
	  XDrawLine(display[pln], radarwin[pln], radargc[pln],
		    x, y - 4, x, y + 4);
	  XDrawLine(display[pln], radarwin[pln], radargc[pln],
		    x - 4, y, x + 4, y);
	}
      
      
      /* Draw wormhole: */
      
      if (wormhole.exist)
	{
	  x = wormhole.x / (WIDTH_OF_WORLD / radargeom[pln].w);
	  y = wormhole.y / (WIDTH_OF_WORLD / radargeom[pln].h);
	  
	  XDrawArc(display[pln], radarwin[pln], radargc[pln],
		   x - 4, y - 4, 8, 8, 0, (360 * 64));
	  XDrawArc(display[pln], radarwin[pln], radargc[pln],
		   x - 2, y - 2, 4, 4, 0, (360 * 64));
	  
	  xx = wormhole.warpx / (WIDTH_OF_WORLD / radargeom[pln].w);
	  yy = wormhole.warpy / (WIDTH_OF_WORLD / radargeom[pln].h);
	  
	  XDrawLine(display[pln], radarwin[pln], radargc[pln],
		    x, y, xx, yy);
	}
    }
  else
    {
      /* Radar is dead! */
      
      for (i = 0; i < RADAR_STATIC; i++)
	{
	  x = rndm(radargeom[pln].w);
	  y = rndm(radargeom[pln].h);
	  
	  XDrawPoint(display[pln], radarwin[pln], radargc[pln], x, y);
	  XDrawPoint(display[pln], radarwin[pln], radargc[pln], x + 1, y);
	  XDrawPoint(display[pln], radarwin[pln], radargc[pln], x + 1, y + 1);
	  XDrawPoint(display[pln], radarwin[pln], radargc[pln], x, y + 1);
	}
    }
}
