/*
  glovar.h
  
  For Final Battle
  
  By Mike Hufnagel and Bill Kendrick
  Previously modified: 11/29/95
  Last modified: 4/2/98
  
  Holds definitions of all global variables for Final Battle.
*/

#ifndef GLOVAR_H
#define GLOVAR_H

#include "types.h"
#include "const.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

Atom OurAtom[SERV];                                 /* Our property atom */
Pixmap shipbitmaps[SERV][SERV][16];                 /* Ships bitmaps... */
Pixmap shipbitmasks[SERV][SERV][16];
Pixmap upgradebitmaps[SERV][UNIQUE_UPGRADES-1][8];  /* Upgrade bitmaps... */
Pixmap upgradebitmasks[SERV][UNIQUE_UPGRADES-1][8];
Pixmap upgradeupgradebitmaps[SERV][UNIQUE_UPGRADES-1]; /* ...for upgradewin */
Pixmap weaponbitmaps[SERV][UNIQUE_WEAPONS];         /* Weapon bitmaps... */
Pixmap weaponbitmasks[SERV][UNIQUE_WEAPONS];
Pixmap weaponweaponbitmaps[SERV][UNIQUE_WEAPONS];   /* Bitmaps for weaponwin */
Pixmap asteroidbitmaps[SERV][16];                   /* Asteroid bitmaps... */
Pixmap asteroidbitmasks[SERV][16];
Pixmap dronebitmaps[SERV];                          /* Drone bitmap... */
Pixmap dronebitmasks[SERV];
Pixmap titlebitmap[SERV];                           /* Title image bitmap */
int screen[SERV], black[SERV], white[SERV],         /* Server stuff... */
  middle[SERV];
int arrow_key[SERV][4];
Display *display[SERV];
int has_color[SERV];
Colormap colormap[SERV];
GC actiongc_white[SERV], actiongc_ship[SERV],       /* Graphic Contexts... */
  actiongc_asteroid[SERV], actiongc_drone[SERV],
  actiongc_upgrade[SERV];
GC actiongc_explode[SERV][3], actiongc_star[SERV][3];
GC actionandgc[SERV], actionorgc[SERV], actioncleargc[SERV];
GC realactiongc[SERV];
GC weapongc[SERV], weapongc_colors[SERV][2];
GC weaponblackgc[SERV], weapongc_hilight[SERV],
  weapongc_middle[SERV], weapongc_shadow[SERV];
GC radargc[SERV];
GC commgc[SERV], radardashedgc[SERV], titlegc[SERV];
GC commgc_message[SERV][NUM_MESSAGES];
GC commgc_highlight[SERV];
GC damagegc[SERV], damagegc_colors[SERV][UNIQUE_DAMAGE_STATES];
GC upgradegc[SERV], upgradegc_colors[SERV][2];
XFontStruct *font[SERV];                            /* Font stuff... */
int fh[SERV];                                       /* (font height) */
Pixmap actionwin[SERV];
Window rootwin[SERV], realactionwin[SERV];          /* Windows... */
Window radarwin[SERV], weaponwin[SERV];
Window damagewin[SERV], commwin[SERV];
Window titlewin[SERV], upgradewin[SERV];
geom actiongeom[SERV], radargeom[SERV];            /* Window geometries... */
geom weapongeom[SERV], damagegeom[SERV];
geom commgeom[SERV], upgradegeom[SERV];
char messages[SERV][NUM_MESSAGES][100];            /* Comm. message space */
char blank_message_str[MAX_MESG_SIZE];             /* Underlines... */
char server[SERV][100], name[SERV][100];           /* Server & user names */
int title_exist[SERV];                             /* Is title GONE yet??? */
int message_size[SERV], sending_message[SERV];     /* Ship-to-ship stuff */
char message_str[SERV][MAX_MESG_SIZE];             /* (mesg. buffer) */
XEvent event;                                      /* The almighty event! */
Window whichwin;                                   /* ...and it's window */
KeySym keysym;                                     /* Keyboard stuff... */
XComposeStatus composestatus;
int current_debris;                                /* Next debris slot */
int current_deadman;                               /* Next deadman slot */
Atom wm_delete_window, wm_protocols;               /* For win-del. trapping */
int titlew, titleh;                                /* Size of title bitmap */
int toggle;                                        /* Toggle flag (for fx) */
playerdata player[SERV];                           /* Data for players... */
stardata star[NUM_STARS];                          /* ...and other objects.. */
asteroiddata asteroid[NUM_ASTEROIDS];
dronedata drone[NUM_DRONES];
upgradedata upgrade[NUM_UPGRADES];
weapondata weapons[NUM_WEAPONS];
debrisdata debris[NUM_DEBRIS];
deadmandata deadman[NUM_DEADMAN];
wormholedata wormhole;

#endif /* GLOVAR_H */
