/*
  damagewin.c
  
  for Final Battle
  
  Mike Hufnagel & Bill Kendrick
  Previously modified: 12/6/95
  Last modified: 11/3/97
  
  Routines to redraw the damages window.
*/

#include <stdio.h>
#include "const.h"
#include "glovar.h"
#include "types.h"
#include "damagewin.h"
#include "lib/text.h"
#include "graphics.h"

void drawdamagewin(int pln)
{
  int i, fh2;
  
  /* Erase window: */
  
  XClearWindow(display[pln], damagewin[pln]);
  
  
  /* Make note of font size: */
  
  fh2 = fh[pln] + 2;
  
  
  /* Table headers */
  
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   0, fh[pln] - 1, "COMPONENT");
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w / 2, fh[pln] - 1, "STATUS");
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w - 24, fh[pln] - 1, "CREW");
  
  
  /* Thick line */
  
  XDrawLine(display[pln], damagewin[pln], damagegc[pln],
	    0, fh2 + 1, damagegeom[pln].w, fh2 + 1);
  XDrawLine(display[pln], damagewin[pln], damagegc[pln],
	    0, fh2, damagegeom[pln].w, fh2);
  
  
  /* Component names */
  
  for (i = 0; i < UNIQUE_DAMAGABLES; i++)
    {
      drawtext(display[pln], damagewin[pln], damagegc[pln],
	       0, (i + 2) * fh2 - 1,
	       damagable_name_strings[i]);
      
      XDrawLine(display[pln], damagewin[pln], damagegc[pln],
		0, (i + 2) * fh2 + 1,
		damagegeom[pln].w, (i + 2) * fh2 + 1);
    }
  
  
  /* Add a couple of more lines for looks. */
  
  XDrawLine(display[pln], damagewin[pln], damagegc[pln],
	    0, (UNIQUE_DAMAGABLES + 5) * fh2 + 1,
	    damagegeom[pln].w, (UNIQUE_DAMAGABLES + 5) * fh2 + 1);
  
  XDrawLine(display[pln], damagewin[pln], damagegc[pln],
	    0, (UNIQUE_DAMAGABLES + 3) * fh2 + 1,
	    damagegeom[pln].w, (UNIQUE_DAMAGABLES + 3) * fh2 + 1);
  
  
  /* Crew status */
  
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   0, (UNIQUE_DAMAGABLES + 2) * fh2 - 1,
	   "Free Crew:");
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w / 2, (UNIQUE_DAMAGABLES + 2) * fh2 - 1,
	   "CryoStored:");
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w - 30, (UNIQUE_DAMAGABLES + 2) * fh2 - 1,
	   "Total:");
  
  
  /* Armor/shields/energy */
  
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   0, (UNIQUE_DAMAGABLES + 4) * fh2 - 1, "Armor:");
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w / 2, (UNIQUE_DAMAGABLES + 4) * fh2 - 1,
	   "Shields:");
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w - 34, (UNIQUE_DAMAGABLES + 4) * fh2 - 1,
	   "Energy:");
  
  updatedamagewin(pln);
}


void updatedamagewin(int pln)
{
  int i, fh2, total;
  char str[100];
  
  
  /* Note font size: */
  
  fh2 = fh[pln] + 2;
  
  
  total = 0;
  
  for (i = 0; i < UNIQUE_DAMAGABLES; i++)
    {
      strcpy(str, damage_name_strings[player[pln].damage[i]]);
      
      drawtext(display[pln], damagewin[pln],
	       damagegc_colors[pln][player[pln].damage[i]],
	       damagegeom[pln].w / 2, (i + 2) * fh2 - 1,
	       str);
      
      sprintf(str, "%d  ", player[pln].crew_working[i]);
      drawtext(display[pln], damagewin[pln], damagegc[pln],
	       damagegeom[pln].w - 20, (i + 2) * fh2 - 1,
	       str);
      
      total = total + player[pln].crew_working[i];
    }
  
  sprintf(str, "%d ", player[pln].crew_free);
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   0, (UNIQUE_DAMAGABLES + 3) * fh2 - 1, str);
  
  sprintf(str, "%d ", player[pln].crew_frozen);
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w / 2, (UNIQUE_DAMAGABLES + 3) * fh2 - 1, str);
  
  sprintf(str, "%d ", player[pln].crew_free + player[pln].crew_frozen + total);
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w - 24, (UNIQUE_DAMAGABLES + 3) * fh2 - 1, str);
  
  updatedefense(pln);
}


void updatedefense(int pln)
{
  int i, fh2;
  char str[100];
  
  fh2 = fh[pln] + 2;
  
  sprintf(str, "%d ", player[pln].armor);
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   0, (UNIQUE_DAMAGABLES + 5) * fh2 - 1, str);
  
  sprintf(str, "%d ", player[pln].shields);
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w / 2, (UNIQUE_DAMAGABLES + 5) * fh2 - 1, str);
  
  sprintf(str, "%u ", player[pln].energy);
  drawtext(display[pln], damagewin[pln], damagegc[pln],
	   damagegeom[pln].w - 34, (UNIQUE_DAMAGABLES + 5) * fh2 - 1, str);
}
