/*
   commwin.c
   
   for Final Battle
   
   By Mike Hufnagel and Bill Kendrick
   Previously modified: 11/18/95
   Last modified: 11/3/97
*/

#include <X11/Xlib.h>
#include "lib/text.h"
#include "commwin.h"
#include "const.h"
#include "glovar.h"
#include "types.h"

void complain(int pln, char *text)
{
  message(pln, "Error", text);
  XBell(display[pln], ERROR_VOLUME);
}

void drawcomm(int pln)
{
  int j, latest_starts_at;
  
  
  /* Erase the window */
  
  XClearWindow(display[pln],commwin[pln]);

  
  /* Find the latest message: */

  latest_starts_at = 0;
  
  for (j = 0; j < NUM_MESSAGES; j++)
    if (messages[pln][j][MAX_NAME_SIZE - 1] != ' ')
      latest_starts_at = j;
  
  
  /* Draw the lines of text messages */
  
  for (j = 0; j < NUM_MESSAGES; j++)
    {
      if (j < latest_starts_at)
	drawtext(display[pln], commwin[pln], commgc_message[pln][j],
		 4, fh[pln] * j + 10, messages[pln][j]);
      else
	drawtext(display[pln], commwin[pln], commgc_highlight[pln],
		 4, fh[pln] * j + 10, messages[pln][j]);
    }
  
  drawtext(display[pln], commwin[pln], commgc[pln],
	   4, fh[pln] * (NUM_MESSAGES + 1) + 10,
	   blank_message_str);
  
  drawtext(display[pln], commwin[pln], commgc[pln],
	   4, fh[pln] * (NUM_MESSAGES + 1) + 10,
	   message_str[pln]);
}

void message(int pln, char *from, char *text)
{
  char format[20];
  int i;
  
  /* Scroll the others up */
  for (i = 0; i < NUM_MESSAGES - 1; i++)
    strcpy(messages[pln][i], messages[pln][i+1]);
  
  /* Add the newest message */
  sprintf(format, "%%%ds:%%s", MAX_NAME_SIZE);
  sprintf(messages[pln][NUM_MESSAGES - 1], format, from, text);

  drawcomm(pln);
}

void message_all(char *from, char *text)
{
  int pln;

  for (pln = 0; pln < SERV; pln++)
    if (player[pln].exist)
      message(pln, from, text);
}

void update_message_str(int pln)
{
  drawtext(display[pln], commwin[pln], commgc[pln], 4,
	   fh[pln] * (NUM_MESSAGES + 1) + 10, "________________________________________");
  drawtext(display[pln], commwin[pln], commgc[pln], 4,
	   fh[pln] * (NUM_MESSAGES + 1) + 10, message_str[pln]);
}
