/********************************************************************************
    Copyright (C) 1999  Dirk Farin

    This program is distributed under GNU Public License (GPL) as
    outlined in the COPYING file that comes with the source distribution.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#include "video12/modules/mcomp_sgl_mmx.hh"

#include <iostream>
#include <iomanip>
using namespace std;


// -------------------------- SINGLE PREDICTION ----------------------------------

static void LumaFF(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp;
        Pixel* dp;

  sp = mc->lastimg.y;
  dp = mc->currimg.y;

  for (int y=mc->blkheight;y>0;y--)
    {
      const uint64* spd = (const uint64*)sp;
            uint64* dpd = (uint64*)dp;

      dpd[ 0]= spd[ 0];
      dpd[ 1]= spd[ 1];

      dp += mc->bytesperline_lum;
      sp += mc->bytesperline_lum;
    }
}

static void LumaHF(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp;
        Pixel* dp;

  sp = mc->lastimg.y;
  dp = mc->currimg.y;

  
  for (int y=0;y<mc->blkheight;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb 1(%0),%%mm1\n\t"
	 "movq  %%mm1,(%1)\n\t"

	 "movq  8(%0),%%mm2\n\t"
 	 "pavgb 9(%0),%%mm2\n\t"
	 "movq  %%mm2,8(%1)\n\t"

	 : : "r"(sp),"r"(dp)
	 );

      sp += mc->bytesperline_lum;
      dp += mc->bytesperline_lum;
    }
}

static void LumaFH(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp;
        Pixel* dp;

  sp = mc->lastimg.y;
  dp = mc->currimg.y;

  for (int y=0;y<mc->blkheight;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb  (%1),%%mm1\n\t"
	 "movq  %%mm1,(%2)\n\t"

	 "movq  8(%0),%%mm2\n\t"
 	 "pavgb 8(%1),%%mm2\n\t"
	 "movq  %%mm2,8(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_lum),"r"(dp)
	 );

      sp += mc->bytesperline_lum;
      dp += mc->bytesperline_lum;
    }
}

static void LumaHH(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp;
  Pixel* dp;

  sp = mc->lastimg.y;
  dp = mc->currimg.y;

  for (int y=0;y<mc->blkheight;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
	 "pavgb 1(%0),%%mm1\n\t"
	 "movq   (%1),%%mm2\n\t"
	 "pavgb 1(%1),%%mm2\n\t"
	 "pavgb %%mm1,%%mm2\n\t"
	 "movq  %%mm2,(%2)\n\t"

	 "movq  8(%0),%%mm1\n\t"
	 "pavgb 9(%0),%%mm1\n\t"
	 "movq  8(%1),%%mm2\n\t"
	 "pavgb 9(%1),%%mm2\n\t"
	 "pavgb %%mm1,%%mm2\n\t"
	 "movq  %%mm2,8(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_lum),"r"(dp)
	 );

      sp += mc->bytesperline_lum;
      dp += mc->bytesperline_lum;
    }
}

static void ChromaFF(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp = mc->lastimg.cr;
        Pixel* dp = mc->currimg.cr;

  int h = mc->blkheight_chr;

  for (int y=0;y<h;y++)
    {
      const uint64* spd = (const uint64*)sp;
            uint64* dpd = (uint64*)dp;

      dpd[ 0]= spd[ 0];

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }


  sp = mc->lastimg.cb;
  dp = mc->currimg.cb;

  for (int y=0;y<h;y++)
    {
      const uint64* spd = (const uint64*)sp;
            uint64* dpd = (uint64*)dp;

      dpd[ 0]= spd[ 0];

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }
}

static void ChromaFH(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp = mc->lastimg.cr;
        Pixel* dp = mc->currimg.cr;

  int h = mc->blkheight_chr;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb  (%1),%%mm1\n\t"
	 "movq  %%mm1,(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_chr),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }


  sp = mc->lastimg.cb;
  dp = mc->currimg.cb;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm2\n\t"
 	 "pavgb  (%1),%%mm2\n\t"
	 "movq  %%mm2, (%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_chr),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }
}

static void ChromaHF(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp = mc->lastimg.cr;
        Pixel* dp = mc->currimg.cr;

  int h = mc->blkheight_chr;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb 1(%0),%%mm1\n\t"
	 "movq  %%mm1,(%1)\n\t"

	 : : "r"(sp),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }


  sp = mc->lastimg.cb;
  dp = mc->currimg.cb;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb 1(%0),%%mm1\n\t"
	 "movq  %%mm1,(%1)\n\t"

	 : : "r"(sp),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }
}

static void ChromaHH(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp = mc->lastimg.cr;
        Pixel* dp = mc->currimg.cr;

  int h = mc->blkheight_chr;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
	 "pavgb 1(%0),%%mm1\n\t"
	 "movq   (%1),%%mm2\n\t"
	 "pavgb 1(%1),%%mm2\n\t"
	 "pavgb %%mm1,%%mm2\n\t"
	 "movq  %%mm2,(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_chr),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }


  sp = mc->lastimg.cb;
  dp = mc->currimg.cb;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
	 "pavgb 1(%0),%%mm1\n\t"
	 "movq   (%1),%%mm2\n\t"
	 "pavgb 1(%1),%%mm2\n\t"
	 "pavgb %%mm1,%%mm2\n\t"
	 "movq  %%mm2,(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_chr),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }
}





static void LumaFFadd(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp;
  Pixel* dp;

  sp = mc->nextimg.y;
  dp = mc->currimg.y;

  for (int y=mc->blkheight;y>0;y--)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
	 "pavgb  (%1),%%mm1\n\t"
	 "movq   %%mm1,(%1)\n\t"

	 "movq   8(%0),%%mm1\n\t"
	 "pavgb  8(%1),%%mm1\n\t"
	 "movq   %%mm1,8(%1)\n\t"

	 : : "r"(sp) ,"r"(dp)
	 );
      
      sp += mc->bytesperline_lum;
      dp += mc->bytesperline_lum;
    }
}

static void LumaHFadd(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp;
        Pixel* dp;

  sp = mc->nextimg.y;
  dp = mc->currimg.y;

  for (int y=0;y<mc->blkheight;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb 1(%0),%%mm1\n\t"
 	 "pavgb  (%1),%%mm1\n\t"
	 "movq  %%mm1,(%1)\n\t"

	 "movq  8(%0),%%mm2\n\t"
 	 "pavgb 9(%0),%%mm2\n\t"
 	 "pavgb 8(%1),%%mm2\n\t"
	 "movq  %%mm2,8(%1)\n\t"

	 : : "r"(sp),"r"(dp)
	 );

      sp += mc->bytesperline_lum;
      dp += mc->bytesperline_lum;
    }
}

static void LumaFHadd(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp;
        Pixel* dp;

  sp = mc->nextimg.y;
  dp = mc->currimg.y;

  for (int y=0;y<mc->blkheight;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb  (%1),%%mm1\n\t"
 	 "pavgb  (%2),%%mm1\n\t"
	 "movq  %%mm1,(%2)\n\t"

	 "movq  8(%0),%%mm2\n\t"
 	 "pavgb 8(%1),%%mm2\n\t"
 	 "pavgb 8(%2),%%mm2\n\t"
	 "movq  %%mm2,8(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_lum),"r"(dp)
	 );

      sp += mc->bytesperline_lum;
      dp += mc->bytesperline_lum;
    }
}

static void LumaHHadd(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp;
        Pixel* dp;

  sp = mc->nextimg.y;
  dp = mc->currimg.y;

  for (int y=0;y<mc->blkheight;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
	 "pavgb 1(%0),%%mm1\n\t"
	 "movq   (%1),%%mm2\n\t"
	 "pavgb 1(%1),%%mm2\n\t"
	 "pavgb %%mm1,%%mm2\n\t"
	 "pavgb  (%2),%%mm2\n\t"
	 "movq  %%mm2,(%2)\n\t"

	 "movq  8(%0),%%mm1\n\t"
	 "pavgb 9(%0),%%mm1\n\t"
	 "movq  8(%1),%%mm2\n\t"
	 "pavgb 9(%1),%%mm2\n\t"
	 "pavgb %%mm1,%%mm2\n\t"
	 "pavgb 8(%2),%%mm2\n\t"
	 "movq  %%mm2,8(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_lum),"r"(dp)
	 );

      sp += mc->bytesperline_lum;
      dp += mc->bytesperline_lum;
    }
}

static void ChromaFFadd(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp = mc->nextimg.cr;
        Pixel* dp = mc->currimg.cr;

  int h = mc->blkheight_chr;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
	 "pavgb  (%1),%%mm1\n\t"
	 "movq   %%mm1,(%1)\n\t"

	 : : "r"(sp) ,"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }


  sp = mc->nextimg.cb;
  dp = mc->currimg.cb;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
	 "pavgb  (%1),%%mm1\n\t"
	 "movq   %%mm1,(%1)\n\t"

	 : : "r"(sp) ,"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }
}

static void ChromaFHadd(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp = mc->nextimg.cr;
        Pixel* dp = mc->currimg.cr;

  int h = mc->blkheight_chr;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb  (%1),%%mm1\n\t"
 	 "pavgb  (%2),%%mm1\n\t"
	 "movq  %%mm1,(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_chr),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }


  sp = mc->nextimg.cb;
  dp = mc->currimg.cb;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb  (%1),%%mm1\n\t"
 	 "pavgb  (%2),%%mm1\n\t"
	 "movq  %%mm1,(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_chr),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }
}

static void ChromaHFadd(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp = mc->nextimg.cr;
        Pixel* dp = mc->currimg.cr;

  int h = mc->blkheight_chr;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb 1(%0),%%mm1\n\t"
 	 "pavgb  (%1),%%mm1\n\t"
	 "movq  %%mm1,(%1)\n\t"

	 : : "r"(sp),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }


  sp = mc->nextimg.cb;
  dp = mc->currimg.cb;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
 	 "pavgb 1(%0),%%mm1\n\t"
 	 "pavgb  (%1),%%mm1\n\t"
	 "movq  %%mm1,(%1)\n\t"

	 : : "r"(sp),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }
}

static void ChromaHHadd(MotionCompensation_SglMB::MCData* mc)
{
  const Pixel* sp = mc->nextimg.cr;
        Pixel* dp = mc->currimg.cr;

  int h = mc->blkheight_chr;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
	 "pavgb 1(%0),%%mm1\n\t"
	 "movq   (%1),%%mm2\n\t"
	 "pavgb 1(%1),%%mm2\n\t"
	 "pavgb %%mm1,%%mm2\n\t"
	 "pavgb  (%2),%%mm2\n\t"
	 "movq  %%mm2,(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_chr),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }


  sp = mc->nextimg.cb;
  dp = mc->currimg.cb;

  for (int y=0;y<h;y++)
    {
      __asm__
	(
	 "movq   (%0),%%mm1\n\t"
	 "pavgb 1(%0),%%mm1\n\t"
	 "movq   (%1),%%mm2\n\t"
	 "pavgb 1(%1),%%mm2\n\t"
	 "pavgb %%mm1,%%mm2\n\t"
	 "pavgb  (%2),%%mm2\n\t"
	 "movq  %%mm2,(%2)\n\t"

	 : : "r"(sp),"r"(sp+mc->bytesperline_chr),"r"(dp)
	 );

      sp += mc->bytesperline_chr;
      dp += mc->bytesperline_chr;
    }
}


static void MC_420_DBL_FFFF_Luma(MotionCompensation_SglMB::MCData* mc) { LumaFF(mc); LumaFFadd(mc); }
static void MC_420_DBL_FHFF_Luma(MotionCompensation_SglMB::MCData* mc) { LumaFF(mc); LumaFHadd(mc); }
static void MC_420_DBL_HFFF_Luma(MotionCompensation_SglMB::MCData* mc) { LumaFF(mc); LumaHFadd(mc); }
static void MC_420_DBL_HHFF_Luma(MotionCompensation_SglMB::MCData* mc) { LumaFF(mc); LumaHHadd(mc); }
static void MC_420_DBL_FFFH_Luma(MotionCompensation_SglMB::MCData* mc) { LumaFH(mc); LumaFFadd(mc); }
static void MC_420_DBL_FHFH_Luma(MotionCompensation_SglMB::MCData* mc) { LumaFH(mc); LumaFHadd(mc); }
static void MC_420_DBL_HFFH_Luma(MotionCompensation_SglMB::MCData* mc) { LumaFH(mc); LumaHFadd(mc); }
static void MC_420_DBL_HHFH_Luma(MotionCompensation_SglMB::MCData* mc) { LumaFH(mc); LumaHHadd(mc); }
static void MC_420_DBL_FFHF_Luma(MotionCompensation_SglMB::MCData* mc) { LumaHF(mc); LumaFFadd(mc); }
static void MC_420_DBL_FHHF_Luma(MotionCompensation_SglMB::MCData* mc) { LumaHF(mc); LumaFHadd(mc); }
static void MC_420_DBL_HFHF_Luma(MotionCompensation_SglMB::MCData* mc) { LumaHF(mc); LumaHFadd(mc); }
static void MC_420_DBL_HHHF_Luma(MotionCompensation_SglMB::MCData* mc) { LumaHF(mc); LumaHHadd(mc); }
static void MC_420_DBL_FFHH_Luma(MotionCompensation_SglMB::MCData* mc) { LumaHH(mc); LumaFFadd(mc); }
static void MC_420_DBL_FHHH_Luma(MotionCompensation_SglMB::MCData* mc) { LumaHH(mc); LumaFHadd(mc); }
static void MC_420_DBL_HFHH_Luma(MotionCompensation_SglMB::MCData* mc) { LumaHH(mc); LumaHFadd(mc); }
static void MC_420_DBL_HHHH_Luma(MotionCompensation_SglMB::MCData* mc) { LumaHH(mc); LumaHHadd(mc); }
              
static void MC_420_DBL_FFFF_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaFF(mc); ChromaFFadd(mc); }
static void MC_420_DBL_FHFF_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaFF(mc); ChromaFHadd(mc); }
static void MC_420_DBL_HFFF_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaFF(mc); ChromaHFadd(mc); }
static void MC_420_DBL_HHFF_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaFF(mc); ChromaHHadd(mc); }
static void MC_420_DBL_FFFH_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaFH(mc); ChromaFFadd(mc); }
static void MC_420_DBL_FHFH_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaFH(mc); ChromaFHadd(mc); }
static void MC_420_DBL_HFFH_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaFH(mc); ChromaHFadd(mc); }
static void MC_420_DBL_HHFH_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaFH(mc); ChromaHHadd(mc); }
static void MC_420_DBL_FFHF_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaHF(mc); ChromaFFadd(mc); }
static void MC_420_DBL_FHHF_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaHF(mc); ChromaFHadd(mc); }
static void MC_420_DBL_HFHF_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaHF(mc); ChromaHFadd(mc); }
static void MC_420_DBL_HHHF_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaHF(mc); ChromaHHadd(mc); }
static void MC_420_DBL_FFHH_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaHH(mc); ChromaFFadd(mc); }
static void MC_420_DBL_FHHH_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaHH(mc); ChromaFHadd(mc); }
static void MC_420_DBL_HFHH_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaHH(mc); ChromaHFadd(mc); }
static void MC_420_DBL_HHHH_Chroma(MotionCompensation_SglMB::MCData* mc) { ChromaHH(mc); ChromaHHadd(mc); }



MotionCompensation_SglMB_MMX::MotionCompensation_SglMB_MMX()
{
  sglluma[0]   = LumaFF;
  sglluma[MC_Last_HalfH] = LumaHF;
  sglluma[MC_Last_HalfV] = LumaFH;
  sglluma[MC_Last_HalfH | MC_Last_HalfV] = LumaHH;

  sglchroma420[0] = ChromaFF;
  sglchroma420[MC_Last_HalfH] = ChromaHF;
  sglchroma420[MC_Last_HalfV] = ChromaFH;
  sglchroma420[MC_Last_HalfH | MC_Last_HalfV] = ChromaHH;

  for (int i=0;i<4;i++)
    {
      sglchroma422[i] = ChromaFF;
      sglchroma444[i] = ChromaFF;
    }

  dblluma[ 0] = MC_420_DBL_FFFF_Luma;
  dblluma[ 1] = MC_420_DBL_FFFH_Luma;
  dblluma[ 2] = MC_420_DBL_FFHF_Luma;
  dblluma[ 3] = MC_420_DBL_FFHH_Luma;
  dblluma[ 4] = MC_420_DBL_FHFF_Luma;
  dblluma[ 5] = MC_420_DBL_FHFH_Luma;
  dblluma[ 6] = MC_420_DBL_FHHF_Luma;
  dblluma[ 7] = MC_420_DBL_FHHH_Luma;
  dblluma[ 8] = MC_420_DBL_HFFF_Luma;
  dblluma[ 9] = MC_420_DBL_HFFH_Luma;
  dblluma[10] = MC_420_DBL_HFHF_Luma;
  dblluma[11] = MC_420_DBL_HFHH_Luma;
  dblluma[12] = MC_420_DBL_HHFF_Luma;
  dblluma[13] = MC_420_DBL_HHFH_Luma;
  dblluma[14] = MC_420_DBL_HHHF_Luma;
  dblluma[15] = MC_420_DBL_HHHH_Luma;

  dblchroma420[ 0] = MC_420_DBL_FFFF_Chroma;
  dblchroma420[ 1] = MC_420_DBL_FFFH_Chroma;
  dblchroma420[ 2] = MC_420_DBL_FFHF_Chroma;
  dblchroma420[ 3] = MC_420_DBL_FFHH_Chroma;
  dblchroma420[ 4] = MC_420_DBL_FHFF_Chroma;
  dblchroma420[ 5] = MC_420_DBL_FHFH_Chroma;
  dblchroma420[ 6] = MC_420_DBL_FHHF_Chroma;
  dblchroma420[ 7] = MC_420_DBL_FHHH_Chroma;
  dblchroma420[ 8] = MC_420_DBL_HFFF_Chroma;
  dblchroma420[ 9] = MC_420_DBL_HFFH_Chroma;
  dblchroma420[10] = MC_420_DBL_HFHF_Chroma;
  dblchroma420[11] = MC_420_DBL_HFHH_Chroma;
  dblchroma420[12] = MC_420_DBL_HHFF_Chroma;
  dblchroma420[13] = MC_420_DBL_HHFH_Chroma;
  dblchroma420[14] = MC_420_DBL_HHHF_Chroma;
  dblchroma420[15] = MC_420_DBL_HHHH_Chroma;
}

MotionCompensation_SglMB::MCompFunc*const*
MotionCompensation_SglMB_MMX::AskMCompFunc_Sgl_Luma() const
{
  return sglluma;
}

MotionCompensation_SglMB::MCompFunc*const*
MotionCompensation_SglMB_MMX::AskMCompFunc_Dbl_Luma() const
{
  return dblluma;
}

MotionCompensation_SglMB::MCompFunc*const*
MotionCompensation_SglMB_MMX::AskMCompFunc_Sgl_Chroma(uint2 chroma) const
{
  return sglchroma420;
}

MotionCompensation_SglMB::MCompFunc*const*
MotionCompensation_SglMB_MMX::AskMCompFunc_Dbl_Chroma(uint2 chroma) const
{
  return dblchroma420;
}

