/********************************************************************************
    Copyright (C) 1999  Dirk Farin

    This program is distributed under GNU Public License (GPL) as
    outlined in the COPYING file that comes with the source distribution.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#include "output/out_x11.hh"
#include "config.h"
#include "libvideogfx/x11/imgwin.hh"


VideoSink_X11::VideoSink_X11()
  : imgwin(NULL), first(true), pic_available(false)
{
}


VideoSink_X11::~VideoSink_X11()
{
  Reset();
}

void VideoSink_X11::Reset()
{
  if (imgwin)
    {
      delete imgwin;
      delete x11img;
      delete transformation;
    }

  imgwin=NULL;
  first=true;
  pic_available=false;
}

#if 1
void VideoSink_X11::ShowMBRows(DecodedImageData* dimg)
{
  const Image<Pixel>& img = dimg->m_image;

  nextpts = dimg->m_timing.pts;

  if (first)
    {
      ImageParam param = img.AskParam();
      d_height = param.height;

      StartAccumulation(0,d_height-1,false);

      imgwin=new ImageWindow_Autorefresh_X11;

      imgwin->SetPosition(10,10);
      imgwin->Create(dimg->m_width,dimg->m_height,
		     "DVDview (c) 1998-2000 Dirk Farin");
  
      first=false;
    }

  DecodedImageData* decimg = Accumulate(dimg);
  if (!decimg)
    return;

  imgwin->Display(decimg->m_image);
}


void VideoSink_X11::FinishedPicture()
{
  pic_available=true;
  StartAccumulation(0,d_height-1,false);
}
#else
void VideoSink_X11::ShowMBRows(DecodedImageData* dimg)
{
  const Image<Pixel>& img = dimg->m_image;

  nextpts = dimg->m_timing.pts;

  if (first)
    {
      ImageParam param = img.AskParam();
      d_height = param.height;

      StartAccumulation(0,d_height-1,false);

      assert(imgwin==NULL);
      imgwin=new ImageWindow_X11;
      x11img=new DisplayImage_X11;
      transformation=new Image2RawRGB;

      imgwin->SetPosition(10,10);
      imgwin->Create(dimg->m_width,dimg->m_height,
		     "DVDview (c) 1998-2000 Dirk Farin");
      x11img->Create(dimg->m_width,dimg->m_height,imgwin->AskWindow());

      XImage& ximg = x11img->AskXImage();

      RawRGBImageSpec spec;
      spec.bytes_per_line = bpl = ximg.bytes_per_line;
      spec.bits_per_pixel = ximg.bits_per_pixel;
      spec.little_endian  = (ximg.byte_order==LSBFirst);
      spec.SetRGBMasks(ximg.red_mask,ximg.green_mask,ximg.blue_mask);

      transformation->SetOutputSpec(spec);
  
      first=false;
    }

  DecodedImageData* decimg = Accumulate(dimg);
  if (!decimg)
    return;

  transformation->TransformYUV(decimg->m_image , (uint8*)(x11img->AskXImage().data));

  x11img->PutImage();
}


void VideoSink_X11::FinishedPicture()
{
  pic_available=true;
  StartAccumulation(0,d_height-1,false);
}
#endif
