/********************************************************************************
    Copyright (C) 1999  Dirk Farin

    This program is distributed under GNU Public License (GPL) as
    outlined in the COPYING file that comes with the source distribution.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#include "error.hh"
// #include "guis/gnome/main_gnome.hh"
#include "guis/shell/main_shell.hh"

#include <iostream>
#include <fstream>
using namespace std;



int main(int argc,char** argv)
{
  ios::sync_with_stdio(false);  // hack to hide performance bug in libstdc++v3

  try
    {
      if (argc==1)
	{ } // start_GUI_gnome(argc,argv); }
      else
	start_GUI_shell(argc,argv);
    }
  catch (const Excpt_Base& e)
    {
      MessageDisplay::Show(e);
    }
  catch (const char* txt)
    {
      cerr << "error: " << txt << endl;
    }
  catch (...)
    {
      cerr << "error occurred... quitting...\n";
    }
}
