/********************************************************************************
  input/streamsrc_udp.hh

  purpose:
    A stream source that receives data from an UDP port.

  notes:

  to do:

  author(s):
   - Craig Rodrigues, crodrigu@bbn.com

  modifications:
    04/Apr/2001 - Craig Rodrigues - first implementation

 ********************************************************************************
    Copyright (C) 1999  Dirk Farin

    This program is distributed under GNU Public License (GPL) as
    outlined in the COPYING file that comes with the source distribution.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#ifndef INPUT_STREAMSRC_UDP_HH
#define INPUT_STREAMSRC_UDP_HH

#include "input/streamsrc.hh"


class StreamSource_udp : public StreamSource
{
public:
   StreamSource_udp();
  ~StreamSource_udp();

  int SetUDPEndpoint(const char *host, uint16 port);

  uint32 FillBuffer(uint8* mem,uint32 maxlen);
  bool   MoreDataPending() const;
  
  bool   IsFiniteStream() const { return false; }
  uint64 AskStreamLength() const;
  
  bool   MaySeek() const { return false; }
  uint64 AskCurrentPosition() const;
  uint64 SetCurrentPosition(uint64);

private:
  uint8 buf[20000];
  int   bufsize;

  uint64 byte_count_;
  int sock_;
};

#endif
