/********************************************************************************
    Copyright (C) 1999  Dirk Farin

    This program is distributed under GNU Public License (GPL) as
    outlined in the COPYING file that comes with the source distribution.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#include "input/streamsrc_udp.hh"
#include "error.hh"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/time.h>

#include <iostream>
using namespace std;




StreamSource_udp::StreamSource_udp()
  : bufsize(0), byte_count_(0)
{
}


StreamSource_udp::~StreamSource_udp()
{
}


int StreamSource_udp::SetUDPEndpoint(const char *host, uint16 port)
{
  int enable = 1L;

  struct sockaddr_in sa;
  struct sockaddr_in mcast_addr;
  struct ip_mreq mcast_req;
  struct hostent *hp;
  unsigned long address;

  memset(&sa, 0, sizeof(sockaddr_in));
  memset(&mcast_addr, 0, sizeof(sockaddr_in));

  hp = gethostbyname(host);
  if(hp == 0)
    {
      perror("Socket error: ");
      return -1;
    }

  sa.sin_family = hp->h_addrtype;
  sa.sin_port = htons (port); 
  address = (unsigned long)(hp->h_addr_list[0]);

  sock_ = socket(AF_INET, SOCK_DGRAM, 0);

  /* Is the address multicast? */
  if((address & 255) >= 224 && (address & 255) <= 239)
    {
      sa.sin_family = AF_INET;
      sa.sin_addr.s_addr = htonl(INADDR_ANY);
      sa.sin_port = htons(port);

      if(bind(sock_, (struct sockaddr*) & sa,
	      sizeof(sa)) < 0)
	{
	  fprintf(stderr, "bind() failed, %s\n", strerror(errno)); 
	  return -1;
	} 

      /* Register to a multicast address */
      mcast_req.imr_multiaddr.s_addr = (unsigned long)hp->h_addr_list[0];
      mcast_req.imr_interface.s_addr = INADDR_ANY;

      if(setsockopt(sock_, IPPROTO_IP, IP_ADD_MEMBERSHIP,
		    (char *) & mcast_req, sizeof(mcast_req)) < 0)
	{
	  fprintf(stderr, "setsockopt() IP_ADD_MEMBERSHIP failed\n");
	  return -1;
	}
    }
  else
    {
      /* address it not multicast, do the regular bind */
      /* Bind the socket to port */
      if(bind(sock_, (struct sockaddr *) & sa, sizeof(sa)) < 0)
	{
	  fprintf(stderr, "bind() failed, %s\n", strerror(errno));
	}                                              
    }


  /* Allow multiple instance of the client to share */
  /* the same address and port */
  if(setsockopt(sock_, SOL_SOCKET, SO_REUSEADDR,
		(char *) &enable, sizeof(unsigned long int)) < 0)
    fprintf(stderr, "setsockopt() SO_REUSEADDR failed, %s\n",
	    strerror(errno));             
}


uint32 StreamSource_udp::FillBuffer(uint8* mem,uint32 maxlen)
{
  struct sockaddr_in from;
  socklen_t i = sizeof(struct sockaddr_in);

  if (maxlen<=bufsize)
    {
      for (int i=0;i<maxlen;i++)
	mem[i]=buf[i];

      for (int i=maxlen;i<bufsize;i++)
	buf[i-maxlen]=buf[i];

      bufsize-=maxlen;

      return maxlen;
    }

  uint32 count = recvfrom(sock_, (char*)&buf[bufsize], 10000, 0,(sockaddr*)&from, &i);

  bufsize+=count;

  return FillBuffer(mem,maxlen);
}


bool StreamSource_udp::MoreDataPending() const
{
  return true;
}


uint64 StreamSource_udp::AskStreamLength() const
{
  return (uint64)(-1);
}


uint64 StreamSource_udp::AskCurrentPosition() const
{
  return byte_count_;
}


uint64 StreamSource_udp::SetCurrentPosition(uint64 pos)
{
  return pos;
}
