/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nquindexer.SaxHTMLIndex;
import com.nexwave.nquindexer.WriteJSFiles;
import com.nexwave.nsidita.DirList;
import com.nexwave.nsidita.DocFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class IndexerMain {
    private String txt_no_inputdir = "Input directory not found:";
    private String txt_cannot_create_outputdir = "Cannot create output search directory.";
    private String txt_no_files_found = "No html files found.";
    private String txt_wrong_dita_basedir = "ERROR: Parser initialization failed. Wrong dita base dir";
    private String txt_no_relative_files_found = "No relative html files calculated.";
    private String txt_no_words_gathered = "No words have been indexed in";
    private String txt_no_html_files = "No HTML Files found in";
    private String txt_no_args = "No argument given: you must provide an htmlDir to the IndexerMain";
    private static String txt_no_lang_specified = "Language of the content is not specified. Defaults to English.";
    private String searchdir = "search";
    private File inputDir = null;
    private String outputDir = null;
    private String projectDir = null;
    public String htmlDir = null;
    public String indexerLanguage = "en";
    private String[] supportedLanguages = new String[]{"en", "de", "fr", "zh", "ja", "ko"};
    private ArrayList<String> cleanUpStrings = null;
    private ArrayList<String> cleanUpChars = null;
    private String htmlExtension = "html";
    public String indexerExcludedFiles = null;
    public String[] splitedStrings = null;
    public String[] regStrings = null;
    private String tocfile;
    private boolean stem;

    public IndexerMain(String string, String string2, String string3, String string4, String string5, String string6) {
        this.setHtmlDir(string);
        this.setIndexerLanguage(string2);
        this.setHtmlextension(string3);
        this.setIndexerExcludedFiles(string6);
        this.splitedStrings = string6.split(",");
        this.regStrings = new String[this.splitedStrings.length + 1];
        for (int i = 0; i < this.splitedStrings.length; ++i) {
            this.regStrings[i] = this.splitedStrings[i];
        }
        if (!string4.toUpperCase().trim().equals("FALSE") && !string4.toUpperCase().trim().equals("NO")) {
            System.out.println("Stemming enabled");
            this.setStem(true);
        } else {
            System.out.println("Stemming disabled");
            this.setStem(false);
        }
        this.setTocfile(string5);
    }

    public IndexerMain(String string, String string2) {
        this.setHtmlDir(string);
        this.setIndexerLanguage(string2);
    }

    public IndexerMain(String string) {
        this.setHtmlDir(string);
        this.setIndexerLanguage("en");
    }

    public void setHtmlDir(String string) {
        this.htmlDir = string;
    }

    public void setIndexerExcludedFiles(String string) {
        this.indexerExcludedFiles = string;
    }

    public void setHtmlextension(String string) {
        this.htmlExtension = string;
        if (this.htmlExtension.startsWith(".")) {
            this.htmlExtension = this.htmlExtension.substring(1);
        }
    }

    public void setIndexerLanguage(String string) {
        if (string != null && !"".equals(string)) {
            int n;
            int n2 = string.indexOf(95);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            for (n = 0; n < this.supportedLanguages.length; ++n) {
                if (!string.equals(this.supportedLanguages[n])) continue;
                this.indexerLanguage = this.supportedLanguages[n];
                break;
            }
            if (n >= this.supportedLanguages.length) {
                this.indexerLanguage = string;
            }
        } else {
            this.indexerLanguage = "@@";
        }
    }

    public static void main(String[] stringArray) {
        if (System.getProperty("htmlDir") == null) {
            throw new RuntimeException("Specify at least the directory containing html files (htmlDir)\n ex: java -jar webhelpindexer.jar -DhtmlDir=docs/content -DindexerLanguage=en \nThe program will exit now.");
        }
        IndexerMain indexerMain = new IndexerMain(System.getProperty("htmlDir"), System.getProperty("indexerLanguage", "en"), System.getProperty("htmlExtension", "html"), System.getProperty("doStem", "true"), System.getProperty("tocFile"), System.getProperty("indexerExcludedFiles"));
        indexerMain.execute();
    }

    public void execute() {
        String string;
        boolean bl;
        File file;
        ArrayList<DocFileInfo> arrayList = null;
        ArrayList<File> arrayList2 = null;
        ArrayList<String> arrayList3 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = "htmlFileInfoList.js";
        String string3 = "htmlFileInfoList.js";
        String string4 = ".js";
        Date date = new Date();
        if (this.htmlDir == null) {
            System.out.println(this.txt_no_args + ".");
            return;
        }
        this.inputDir = new File(this.htmlDir);
        if (this.inputDir == null) {
            IndexerMain.DisplayHelp();
            return;
        }
        if (!this.inputDir.exists()) {
            System.out.println(this.txt_no_inputdir + " " + this.inputDir + ".");
            return;
        }
        if (this.outputDir == null) {
            this.outputDir = this.inputDir.getPath().concat(File.separator).concat(this.searchdir);
        }
        if (!(file = new File(this.outputDir)).exists() && !(bl = file.mkdirs())) {
            System.out.println(this.txt_cannot_create_outputdir + " " + this.outputDir + ".");
            return;
        }
        if (this.projectDir == null) {
            this.projectDir = this.inputDir.getPath();
        }
        this.regStrings[this.regStrings.length - 1] = string = "^.*\\." + this.htmlExtension + "?$";
        DirList dirList = new DirList(this.inputDir, this.regStrings, 1);
        arrayList2 = dirList.getListFiles();
        if (arrayList2.isEmpty()) {
            System.out.println(this.txt_no_html_files + " " + this.inputDir + ".");
            return;
        }
        arrayList3 = dirList.getListFilesRelTo(this.projectDir);
        Iterator<String> iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().endsWith(this.tocfile + "." + this.htmlExtension)) continue;
            iterator.remove();
        }
        if (arrayList2 == null) {
            System.out.println(this.txt_no_files_found);
            return;
        }
        if (arrayList3 == null) {
            System.out.println(this.txt_no_relative_files_found);
            return;
        }
        WriteJSFiles.WriteHTMLList(this.outputDir.concat(File.separator).concat(string2), arrayList3, this.stem);
        SaxHTMLIndex saxHTMLIndex = new SaxHTMLIndex(this.cleanUpStrings, this.cleanUpChars);
        if (saxHTMLIndex.init(hashMap) == 0) {
            Comparable<File> comparable;
            arrayList = new ArrayList<DocFileInfo>();
            Iterator<File> iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                comparable = iterator2.next();
                if (!((File)comparable).getAbsolutePath().endsWith(this.tocfile + "." + this.htmlExtension)) {
                    DocFileInfo docFileInfo = new DocFileInfo(saxHTMLIndex.runExtractData((File)comparable, this.indexerLanguage, this.stem));
                    String string5 = ((File)(comparable = docFileInfo.getFullpath())).toString();
                    int n = string5.indexOf(this.projectDir);
                    if (n != 0) {
                        System.out.println("the documentation root does not match with the documentation input!");
                        return;
                    }
                    int n2 = 1;
                    if (string5.equals(this.projectDir)) {
                        n2 = 0;
                    }
                    string5 = string5.substring(n + this.projectDir.length() + n2);
                    comparable = new File(string5);
                    docFileInfo.setFullpath((File)comparable);
                    arrayList.add(docFileInfo);
                    continue;
                }
                iterator2.remove();
            }
            if (hashMap.containsKey("")) {
                hashMap.remove("");
            }
            if (hashMap.isEmpty()) {
                System.out.println(this.txt_no_words_gathered + " " + this.inputDir + ".");
                return;
            }
            WriteJSFiles.WriteIndex(this.outputDir.concat(File.separator).concat(string4), hashMap, this.indexerLanguage);
            WriteJSFiles.WriteHTMLInfoList(this.outputDir.concat(File.separator).concat(string3), arrayList);
            comparable = new Date();
            long l = ((Date)comparable).getTime() - date.getTime();
            if (l < 1000L) {
                System.out.println("Indexed the contents in " + l + " milliseconds");
            } else {
                System.out.println("Indexed the contents in " + l / 1000L + " seconds");
            }
        } else {
            System.out.println(this.txt_wrong_dita_basedir);
        }
    }

    private static void DisplayHelp() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("USAGE:").append(string);
        stringBuilder.append("   java -classpath TesterIndexer inputDir outputDir projectDir").append(string);
        stringBuilder.append("with:").append(string);
        stringBuilder.append("   inputDir (mandatory) :  specify the html files ' directory to index").append(string);
        stringBuilder.append("   outputDir (optional) : specify where to output the index files").append(string);
        stringBuilder.append("   projectDir (optional) : specify the root of the documentation directory").append(string);
        stringBuilder.append("Example:").append(string);
        stringBuilder.append("   java -classpath TesterIndexer /home/$USER/DITA/doc").append(string);
        stringBuilder.append("Example 2:").append(string);
        stringBuilder.append("   java -classpath TesterIndexer /home/$USER/webhelp/docs/content /home/$USER/docs/content/search /home/$USER/webhelp/docs").append(string);
        System.out.println(stringBuilder.toString());
    }

    private int RetrieveCleanUpProps() {
        String[] stringArray = new String[]{"punctuation.props"};
        Collection<Object> collection = new ArrayList();
        DirList dirList = new DirList(this.inputDir, stringArray, 1);
        ArrayList<File> arrayList = dirList.getListFiles();
        Properties properties = new Properties();
        String string = this.inputDir.getPath().concat(File.separator).concat(this.searchdir);
        this.cleanUpStrings = new ArrayList();
        this.cleanUpChars = new ArrayList();
        try {
            FileInputStream fileInputStream;
            File file;
            for (File file2 : arrayList) {
                file = file2;
                if (!file.exists()) continue;
                fileInputStream = new FileInputStream(file.getAbsolutePath());
                properties.load(fileInputStream);
                fileInputStream.close();
                collection = properties.values();
                this.cleanUpStrings.addAll(collection);
                properties.clear();
            }
            for (String string2 : stringArray) {
                String string3 = string.concat(File.separator).concat(string2);
                file = new File(string3);
                if (!file.exists()) continue;
                fileInputStream = new FileInputStream(string3);
                properties.load(fileInputStream);
                fileInputStream.close();
                collection = properties.values();
                this.cleanUpChars.addAll(collection);
                properties.clear();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 1;
        }
        return 0;
    }

    public void setTocfile(String string) {
        this.tocfile = string;
    }

    public void setStem(boolean bl) {
        this.stem = bl;
    }
}

