/*
 * RESUME
 *
 * resume.c - Dump y Resume de sesiones de escaneo
 *
 */

#include "dirb.h"


/*
 * DUMP: Vuelca a fichero el estado de una sesion de escaneo
 *
 */

void dump(void) {
  FILE *dumpfile;
  struct words *current;
  struct stat buffer;

  struct tm *ptr;
  time_t tm;

  tm = time(NULL);
  ptr = localtime(&tm);

  if(options.debuging>2) printf("[++] dump() Dumping Session State AT %s", asctime(ptr)); fflush(stdout);


  // Comprobamos si existe el directorio

  if(stat(DUMP_DIR, &buffer)<0) {

    if(mkdir(DUMP_DIR, S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH)<0) {
      printf("\n(!) FATAL: Error creating resume directory: %s\n", DUMP_DIR);
      exit(-1);
      }

    }


  // Volcamos la estructura options

  unlink(OPTIONS_DUMP);
  dumpfile=abrir_file(OPTIONS_DUMP);

  fwrite(&options, sizeof(struct opciones), 1, dumpfile);

  fclose(dumpfile);


  // Volcamos la wordlist

  unlink(WORDLIST_DUMP);
  dumpfile=abrir_file(WORDLIST_DUMP);

  current=wordlist_base;

  while(current->siguiente!=0) {
    if(options.debuging>6) printf("[++++++] dump() WORD: %s\n", current->word);
    fwrite(current->word, strlen(current->word), 1, dumpfile);
    fwrite("\n", 1, 1, dumpfile);
    current=current->siguiente;
    }

  fclose(dumpfile);


  // Volvamos la dirlist

  unlink(DIRLIST_DUMP);
  dumpfile=abrir_file(DIRLIST_DUMP);

  current=dirlist_current;

  while(current->siguiente!=0) {
    if(options.debuging>6) printf("[++++++] dump() DIR: %s\n", current->word);
    fwrite(current->word, strlen(current->word), 1, dumpfile);
    fwrite("\n", 1, 1, dumpfile);
    current=current->siguiente;
    }

  fclose(dumpfile);


}


/*
 * RESUME: Restaura el estado de una sesion de escaneo
 *
 */

void resume(void) {
  FILE *desc;

  resuming=1;


  // Recuperamos la estructura options

  if((desc=fopen(OPTIONS_DUMP, "r"))==0) {
    printf("\n(!) FATAL: Error opening input file: %s\n", OPTIONS_DUMP);
    exit(-1);
    }

  fread(&options, sizeof(struct opciones), 1, desc);

  fclose(desc);


  // Inicializamos

  check_url(options.current_dir);

  get_options();

  init_exts();

  IMPRIME("CURRENT_BASE: %s\n", options.current_dir);

  IMPRIME("CURRENT_WORD: %s\n", options.current_word);

  IMPRIME("\n-----------------\n\n");


  // Mutations

  /*
  if(options.mutations_file) {
    muts_base=crea_wordlist_fich(options.mutation_file);
    } else if(options.mutations_list) {
    muts_base=crea_extslist(options.mutation_list);
    }
  */

  // Recuperamos la dirlist

  dirlist_current=crea_wordlist_fich(DIRLIST_DUMP);

  dirlist_base=dirlist_current;
  while(dirlist_current->siguiente!=0) { dirlist_current=dirlist_current->siguiente; }
  dirlist_final=dirlist_current;
  dirlist_current=dirlist_base;


  // Recuperamos la wordlist

  wordlist_current=crea_wordlist_fich(WORDLIST_DUMP);

  wordlist_base=wordlist_current;
  while(wordlist_current->siguiente!=0) { wordlist_current=wordlist_current->siguiente; }
  wordlist_final=wordlist_current;
  wordlist_current=wordlist_base;

  while(wordlist_current->siguiente!=0 && strncmp(wordlist_current->word, options.current_word, STRING_SIZE-1)!=0) { wordlist_current=wordlist_current->siguiente; }


  // Relanzamos el scan

  lanza_ataque(options.current_dir, wordlist_current);

  // Finalizamos

  cierre();
  exit(0);

}



