/*
* solver.h
* DIN Is Noise is copyright (c) 2006-2025 Jagannathan Sampath
* For more information, please visit http://dinisnoise.org/
*/


#ifndef __SOLVER__
#define __SOLVER__

#include "crvpt.h"
#include "multi_curve.h"
#include "xhandler.h"
#include <vector>

struct solver {

  //
  // given x on curve, return y
  //

  // solved curve
  multi_curve* mcrv;

  // multi_curve is collection of bezier curves
  int ncurvs, icurv, last_curv;
  int iseg;

  // line segment on curve expected to contain x
  float startx, starty;
  float endx, endy;
  float m;
  int inf;
  float ycomp;

  // first and last points of curve
  float firstx, firsty;
  float lastx, lasty;
	float deltax;
  float pinx;

  float result; // last result
  
  int seg_lte_right (float x, int c, int i);
	int seg_gte_left (float x, int c, int i);
  void setseg (int c, int i);
 
  inline int lastseg (int c) {
    std::vector<crvpt>& vpts = mcrv->get_profile_points (c);
    return vpts.size() - 2;
  }

  inline int numsegs (int c) {
    return (mcrv->get_profile_points(c).size () - 1);
  }

  int searchleft (float x);
  int searchright (float x);
  int findseg (float x);
  
  solver ();
  solver (multi_curve* crv);

  void operator() (multi_curve* crv);

	void check (float& x, float& dx, xhandler& xmin, xhandler& xmax);

  // given x, solve y
  float operator() (float x);
  float operator() (float &x, float& dx, xhandler& xmin, xhandler& xmax);

  // fast solver when x is incremented by dx n times, solution stored in y
  void operator() (float& x, float& dx, int n, float* y, xhandler& xmin = _tomax, xhandler& xmax = _tomin); // dx as constant value
  void operator() (float& x, float* pdx, int n, float* y, xhandler& xmin = _tomax, xhandler& xmax = _tomin); // dx as variable value array

  // same as fast solver but x is also modulated by mod.
  void operator() (float& x, float& dx, int n, float* mod, float* soln, xhandler& xmin = _tomax, xhandler& xmax = _tomin);
  void operator() (float& x, float* pdx, int n, float* mod, float* y, xhandler& xmin = _tomax, xhandler& xmax = _tomin); 

  // given an array of x, store solution in same array
  void operator() (float* ax, int n, float& x, xhandler& xmin = _atmin, xhandler& xmax = _atmax);
  void operator() (float* ax, int n, xhandler& xmin = _atmin, xhandler& xmax = _atmax);
  void operator() (float* ax1, float* ax2, int n, xhandler& xmin = _atmin, xhandler& xmax = _atmax);

  void init ();
  
  void update (); // when multi curve has changed

};

extern solver warp_pitch, warp_vol;
extern solver warp_depth, warp_bpm;

#endif
