#!/usr/local/bin/perl
# $Id: create_fsi.pl,v 1.1 1995/07/06 13:42:22 ww0r Exp $ 
#
# create-fsi directory [versiondelimiter]
#     creates fsi images for each collection in the directory specified
# /tmp/releaseme - list of volumes that need to be released
#
# note: we just included list-ver.pl to get the directories.

$| = 1;
$dir = $ARGV[0];
if ($ARGV[1]) {
  $delim = $ARGV[1];
  chop($delim);			# ditch \n
} else {
  $delim = '.';
}

die "Invalid directory $dir\n"
  if (! -d "$dir");

print "opening directory...";
opendir(DP, "$dir") 
  || die "Can't open directory: $dir: $!\n";

print "reading entries...";
@items = grep (!/^\.\.?$/, 
	       grep (-d "$dir/$_" , readdir(DP)));
closedir(DP);

print "processing entries...";
$char = "\\" . $delim;
foreach (@items) {
  next 
    if (($_ eq "sun4c_411")
	|| ($_ eq "sun4_413"));

  ($name, $ver) = split(/$char/);
  $ver = -1
    if (!defined $ver);
  next
    if ((defined $col{$name}) && ($ver < $col{$name}));
  $col{$name} = $ver;
}

print "done.\n";

open(FD,">/tmp/releaseme") 
  || die "Can't open file /tmp/releaseme: $!\n";

foreach (sort keys %col) {
  if ($col{$_} == -1) {
    $entry = $_;
  } else {
    $entry = "$_$delim$col{$_}";
  }
  print "Processing $entry...";

# unlock the collection
  print "unlocking...";
  `fs sa $entry ww0r.admin write > /dev/null`;
  die "error running fs sa : $!\n"
    if ($? != 0);

# bump up the quota;
  print "checking quota...";
  @in = `fs lq $entry`;
  die "error getting quota : $!\n"
    if ($? != 0);

  ($volume, $quota, $usage) = split(/\s+/,$in[1]);

  if (($usage * 1.20) > $quota) {
    print "upping quota...";
    # bump up the quota by 10 meg... more than enough
    local($upquota) = $quota + 10;
    `fs sq $entry $upquota`;
    die "error setting quota : $!\n"
      if ($? != 0);
  }

  print "generating image...";
  `fsi_generate $entry >$entry/depot.image`;
  die "error running fsi_generate: $!\n"
    if ($? != 0);

  print "setting hints...";
  `hintservice -set depot.hint -image $entry/depot.image $entry`;
  die "error running hintservice: $!\n"
    if ($? != 0);    

  # relock the volume
  print "locking volume...";
  `fs sa $entry ww0r.admin none > /dev/null`;
  die "error running fs sa : $!\n"
    if ($? != 0);


  print "checking for replica's...";
  `vos volinfo $volume.readonly > /dev/null 2>&1`;
  print FD "$volume\n"
    if ($? == 0);

  print "done\n";
  $? = 0;
}
close(FD);

# $Source: /afs/andrew.cmu.edu/system/src/local/depot2/021/tools/conv_tools/RCS/create_fsi.pl,v $
