/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: TargetDB_Special.c,v 1.5 1995/05/11 17:44:46 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"



TARGETDB *
TargetDB_ProtectSpecialTargets(targetdbp, specialfilelist)
     TARGETDB *targetdbp;
     char **specialfilelist;
{
  register char **sp;

  TARGETDB *newtargetdbp;

  TARGETDBENTRY *targetdbnodep;
  Boolean SpecialTargetExists;

  newtargetdbp = targetdbp;
  if (specialfilelist != NULL) {
    for (sp = specialfilelist;
	 (PROGRAM_ErrorNo == E_NULL) && (*sp != NULL);
	 sp++) {
      SpecialTargetExists = TRUE;
      targetdbnodep = TargetDB_LocateNode(targetdbp, *sp, TDB_LAX);
      if ((PROGRAM_ErrorNo == E_NULL) && (targetdbnodep == NULL)) {
	SpecialTargetExists = TargetDB_CheckPathHierarchy(*sp);
      }
      if ((PROGRAM_ErrorNo == E_NULL) &&
	  ((targetdbnodep != NULL) || SpecialTargetExists)) {
	newtargetdbp = TargetDB_CreateTargetPath(newtargetdbp,
						 *sp,
						 U_SPECIAL);
	if (PROGRAM_ErrorNo == E_NULL)
	  targetdbnodep = TargetDB_LocateNode(targetdbp, *sp, TDB_LAX);
      }
      if ((PROGRAM_ErrorNo == E_NULL)
	  && (targetdbnodep != NULL)
	  && (TARGETDB_SourceList(targetdbnodep) != NULL)
	  && (TARGETSOURCELIST_NSources(TARGETDB_SourceList(targetdbnodep))
	      != 0)) {
	Filtered_Message(PROGRAM_Verbose == PROGRAM_TRACEVAL,
			 "Attempt to update specail file at %s.",
			 *sp);
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newtargetdbp : NULL;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/020/src/lib/TargetDB/RCS/TargetDB_Special.c,v $ */
