/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: SourceList_Merge.c,v 1.6 1994/08/12 22:18:14 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "TargetDB.h"


static TARGETSOURCELIST *CollectionSourceList_MergeSource();



/*
 * PRECONDITIONS : (sourcelistp != NULL) && (sourcep != NULL)
 *
 * $$$NOTE$$$: This is similar to Collection_SourceList_AddSource().
 * Merge the two later, if resultant code is not too unreadable.
 */
static TARGETSOURCELIST *
CollectionSourceList_MergeSource(sourcelistp,
				 sourcep,
				 collectionid,
				 newpathtosources)
     TARGETSOURCELIST *sourcelistp;
     TARGETSOURCE *sourcep;
     int collectionid;
     Boolean newpathtosources;
{
  register TARGETSOURCE **fp, **tp;
  register TARGETSOURCE *sp;
  register unsigned int i;

  TARGETSOURCELIST *newsourcelistp;

  int InsertionPoint;
  Boolean FoundInsertionPoint, DuplicateSource, FoundConflict;
  TARGETSOURCE *secp1, *secp2;

  if (((TARGETSOURCE_UpdateSpec(sourcep)
	& (U_MAP | U_MAPCOPY | U_MAPLINK | U_MKDIR | U_HARDLINK | U_COMMAND
	   | U_NONVIRGIN | U_COMMANDPATH))
       != TARGETSOURCE_UpdateSpec(sourcep))
      || !(TARGETSOURCE_UpdateSpec(sourcep)
	   & (U_MAP | U_MKDIR | U_HARDLINK | U_COMMAND))) {
    FatalError(E_BADSOURCEUPDTSPEC,
	       "Bad update specification %x for source in merge.\n",
	       TARGETSOURCE_UpdateSpec(sourcep));
  }
  newsourcelistp = sourcelistp;
  if ((PROGRAM_ErrorNo == E_NULL) && (newsourcelistp == NULL)) {
    newsourcelistp = (TARGETSOURCELIST *) emalloc(sizeof(TARGETSOURCELIST));
    if (PROGRAM_ErrorNo == E_NULL) {
      TARGETSOURCELIST_NSources(newsourcelistp) = 0;
      TARGETSOURCELIST_SourceArray(newsourcelistp) = NULL;
    }
  }
  /* locate insertion point for source */
  if (PROGRAM_ErrorNo == E_NULL) {
    i = 0;
    FoundInsertionPoint = FALSE;
    InsertionPoint = 0;
    DuplicateSource = FALSE;
    FoundConflict = FALSE;
    while (!FoundConflict && (i < TARGETSOURCELIST_NSources(newsourcelistp))) {
      sp = TARGETSOURCELIST_Source(newsourcelistp, i);
      if (TARGETSOURCE_UpdateSpec(sourcep) & (U_MAP | U_HARDLINK)) {
	secp1 = TARGETSOURCE_SecondarySource(sourcep);
	secp2 = TARGETSOURCE_SecondarySource(sp);
	if (TARGETSOURCE_UpdateSpec(sp) & (U_MAP | U_HARDLINK)) {
	  if (!newpathtosources
	      && (String_Comparator(TARGETSOURCE_Path(sourcep),
				    TARGETSOURCE_Path(sp)) == 0)
	      && ((TARGETSOURCE_UpdateSpec(sourcep)
		   & (U_MAP | U_MAPCOPY | U_MAPLINK | U_HARDLINK))
		  == (TARGETSOURCE_UpdateSpec(sp)
		      & (U_MAP | U_MAPCOPY | U_MAPLINK | U_HARDLINK)))
	      && (TargetSource_DuplicateComparator(secp1, secp2) == TRUE)) {
	    DuplicateSource = TRUE;
	    TARGETSOURCE_Status(sp) &= ~S_OBSOLETE;
	    TARGETSOURCE_Status(sp) |= S_MODIFIED;
	    secp2 = TARGETSOURCE_SecondarySource(sp);
	    while (secp2 != NULL) {
	      TARGETSOURCE_Status(secp2) &= ~S_OBSOLETE;
	      TARGETSOURCE_Status(secp2) |= S_MODIFIED;
	      secp2 = TARGETSOURCE_SecondarySource(secp2);
	    }
	  } else if (!(TARGETSOURCE_Status(sp) & S_OBSOLETE)) {
	    FoundConflict = TRUE;
	    TargetDB_ReportMergeConflict(sourcep, sp);
	  }
	} else if (TARGETSOURCE_UpdateSpec(sp) & U_MKDIR) {
	  if (TARGETSOURCE_Status(sp) & S_OBSOLETE) {
	    if (!FoundInsertionPoint) {
	      InsertionPoint = i;
	      FoundInsertionPoint = TRUE;
	    }
	  } else {
	    FoundConflict = TRUE;
	    TargetDB_ReportMergeConflict(sourcep, sp);
	  }
	} else if (TARGETSOURCE_UpdateSpec(sp) & U_COMMAND) {
	  if (!FoundInsertionPoint) {
	    InsertionPoint = i;
	    FoundInsertionPoint = TRUE;
	  }
	}
      } else if (TARGETSOURCE_UpdateSpec(sourcep) & U_MKDIR) {
	if (TARGETSOURCE_UpdateSpec(sp) & (U_MAP | U_HARDLINK | U_COMMAND)) {
	  if (TARGETSOURCE_Status(sp) & S_OBSOLETE) {
	    if (!FoundInsertionPoint) {
	      InsertionPoint = i;
	      FoundInsertionPoint = TRUE;
	    }
	  } else {
	    FoundConflict = TRUE;
	    TargetDB_ReportMergeConflict(sourcep, sp);
	  }
	} else {		/* TARGETSOURCE_UpdateSpec(sp) & U_MKDIR */
	  if (!newpathtosources
	      && !DuplicateSource
	      && (TARGETSOURCE_Status(sp)
		  & (S_OBSOLETE | S_UNOBSOLETEDSUBTREE))
	      && (String_Comparator(TARGETSOURCE_Path(sourcep),
				    TARGETSOURCE_Path(sp)) == 0)
	      && (TargetSource_Comparator
		  (TARGETSOURCE_SecondarySource(sourcep),
		   TARGETSOURCE_SecondarySource(sp)) == TRUE)
	      && ((TARGETSOURCE_UpdateSpec(sourcep)
		   & (U_MAPCOPY | U_MAPLINK))
		  == (TARGETSOURCE_UpdateSpec(sp)
		      & (U_MAPCOPY | U_MAPLINK)))) {
	    DuplicateSource = TRUE;
	    TARGETSOURCE_Status(sp) &= ~S_OBSOLETE;
	    TARGETSOURCE_Status(sp) |= S_MODIFIED;
	  }
	}
      } else {			/* (TARGETSOURCE_UpdateSpec(sourcep) &
				 * U_COMMAND) */
	if (TARGETSOURCE_UpdateSpec(sp) & U_MKDIR) {
	  if (TARGETSOURCE_Status(sp) & S_OBSOLETE) {
	    if (!FoundInsertionPoint) {
	      InsertionPoint = i;
	      FoundInsertionPoint = TRUE;
	    }
	  } else {
	    FoundConflict = TRUE;
	    TargetDB_ReportMergeConflict(sourcep, sp);
	  }
	} else if (TARGETSOURCE_UpdateSpec(sp) & U_COMMAND) {
	  if (!newpathtosources
	      && (String_Comparator(TARGETSOURCE_Path(sourcep),
				    TARGETSOURCE_Path(sp)) == 0)
	      && (TargetSource_Comparator
		  (TARGETSOURCE_SecondarySource(sourcep),
		   TARGETSOURCE_SecondarySource(sp)) == TRUE)) {
	    DuplicateSource = TRUE;
	    TARGETSOURCE_Status(sp) &= ~S_OBSOLETE;
	    TARGETSOURCE_Status(sp) |= S_MODIFIED;
	  } else if (!(TARGETSOURCE_Status(sp) & S_OBSOLETE)) {
	    FoundConflict = TRUE;
	    TargetDB_ReportMergeConflict(sourcep, sp);
	  }
	}
      }
      i++;
    }
    if (!FoundInsertionPoint) {
      InsertionPoint = TARGETSOURCELIST_NSources(newsourcelistp);
      FoundInsertionPoint = TRUE;
    }
  }
  /* if not a duplicate source, insert source at InsertionPoint */
  if ((PROGRAM_ErrorNo == E_NULL) && !DuplicateSource && !FoundConflict) {
    if (!FoundInsertionPoint) {	/* never happens! */
      FatalError(E_BADTARGETSOURCE,
		 "Attempt to merge source failed unexpectedly!\n");
    } else {
      TARGETSOURCELIST_NSources(newsourcelistp)++;
      if (TARGETSOURCELIST_NSources(newsourcelistp) == 1) {
	TARGETSOURCELIST_SourceArray(newsourcelistp) =
	  (TARGETSOURCE **) emalloc(sizeof(TARGETSOURCE *));
      } else {
	TARGETSOURCELIST_SourceArray(newsourcelistp) =
	  (TARGETSOURCE **)
	  erealloc((void *) TARGETSOURCELIST_SourceArray(newsourcelistp),
		   TARGETSOURCELIST_NSources(newsourcelistp)
		   * sizeof(TARGETSOURCE *));
	i = TARGETSOURCELIST_NSources(newsourcelistp) - 1;
	tp = TARGETSOURCELIST_SourceArray(newsourcelistp) + i;
	fp = tp - 1;
	while ((PROGRAM_ErrorNo == E_NULL) && (i > InsertionPoint)) {
	  *tp-- = *fp--, i--;
	}
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	TARGETSOURCE_Status(sourcep) |= S_MODIFIED;
	TARGETSOURCELIST_Source(newsourcelistp,
				InsertionPoint) = TargetSource(sourcep);
      }
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newsourcelistp : NULL;
}



TARGETSOURCELIST *
SourceList_Merge(sourcelistp,
		 deltasourcelistp,
		 newpathtosources)
     TARGETSOURCELIST *sourcelistp;
     TARGETSOURCELIST *deltasourcelistp;
     Boolean newpathtosources;
{
  register unsigned int i, j;

  TARGETSOURCELIST *newsourcelistp;

  int collectionid;
  TARGETSOURCELIST *collectionsourcelistp;
  TARGETSOURCE *deltasourcep;
  Boolean LocatedCollection, PastCollection;
  int collectionbegin, collectionend, InsertPoint;
  int oldcollectionsourcelistsize, newcollectionsourcelistsize;
  int oldsourcelistsize;

  if (deltasourcelistp == NULL) {
    FatalError(E_BADTARGETSOURCE,
	       "Attempt to append NULL source to targetsourcelist.\n");
  }
  newsourcelistp = sourcelistp;
  if ((PROGRAM_ErrorNo == E_NULL) && (newsourcelistp == NULL)) {
    newsourcelistp = (TARGETSOURCELIST *) emalloc(sizeof(TARGETSOURCELIST));
    if (PROGRAM_ErrorNo == E_NULL) {
      TARGETSOURCELIST_NSources(newsourcelistp) = 0;
      TARGETSOURCELIST_SourceArray(newsourcelistp) = NULL;
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (TARGETSOURCELIST_NSources(newsourcelistp) == 0) {
      if (newsourcelistp != NULL) 
	free(newsourcelistp);
      newsourcelistp = SourceList(deltasourcelistp);
    } else if (TARGETSOURCELIST_NSources(deltasourcelistp) >= 0) {
      collectionid =
	TARGETSOURCE_CollectionId(TARGETSOURCELIST_Source(deltasourcelistp,
							  0));

      /* extract contribution of collection from sourcelist */
      collectionbegin = SourceList_FindIndexToCollectionId(newsourcelistp,
							   collectionid,
							   TDB_LAX);
      if (collectionbegin >= 0) {
	LocatedCollection = TRUE;
	InsertPoint = collectionbegin;
      } else {
	LocatedCollection = FALSE;
	InsertPoint = TARGETSOURCELIST_NSources(newsourcelistp);
      }

      if ((PROGRAM_ErrorNo == E_NULL) && LocatedCollection) {
	i = collectionbegin + 1;
	PastCollection = FALSE;
	while ((PROGRAM_ErrorNo == E_NULL)
	       && (i < TARGETSOURCELIST_NSources(newsourcelistp))
	       && !PastCollection) {
	  if (TARGETSOURCE_CollectionId
	      (TARGETSOURCELIST_Source(newsourcelistp, i))
	      != collectionid) {
	    PastCollection = TRUE;
	    collectionend = i - 1;
	  }
	  i++;
	}
	if ((PROGRAM_ErrorNo == E_NULL) && !PastCollection)
	  collectionend = TARGETSOURCELIST_NSources(newsourcelistp) - 1;
      }
      if (PROGRAM_ErrorNo == E_NULL) {
	if (LocatedCollection) {
	  collectionsourcelistp = SourceList_SubList(newsourcelistp,
						     collectionbegin,
						     collectionend);
	  oldcollectionsourcelistsize = collectionend - collectionbegin + 1;
	} else {
	  collectionsourcelistp = NULL;
	  oldcollectionsourcelistsize = 0;
	}
      }
      /* merge deltasourcelistp into extracted contribution */
      if (PROGRAM_ErrorNo == E_NULL) {
	if (collectionsourcelistp == NULL) {
	  collectionsourcelistp = SourceList(deltasourcelistp);
	} else {
	  /* 
	   * foreach source in deltasourcelistp
	   *    merge source into collectionsourcelistp;
	   */

	  for (i = 0;
	       (PROGRAM_ErrorNo == E_NULL)
	       && (i < TARGETSOURCELIST_NSources(deltasourcelistp));
	       i++) {
	    deltasourcep = TARGETSOURCELIST_Source(deltasourcelistp, i);
	    collectionsourcelistp =
	      CollectionSourceList_MergeSource(collectionsourcelistp,
					       deltasourcep,
					       collectionid,
					       newpathtosources);
	  }
	}
      }
      /* realloc newsourcelist to hold new size of collectionsourcelistp */
      if (PROGRAM_ErrorNo == E_NULL) {
	newcollectionsourcelistsize =
	  TARGETSOURCELIST_NSources(collectionsourcelistp);
	oldsourcelistsize = TARGETSOURCELIST_NSources(newsourcelistp);
	if (newcollectionsourcelistsize < oldcollectionsourcelistsize) {
	  /* error - size of collectionsourcelistp should not shrink */
	  FatalError(E_BADTARGETSOURCELIST,
		     "Unexpected loss of sources in sourcelist merge.\n");
	} else if (newcollectionsourcelistsize > oldcollectionsourcelistsize) {
	  TARGETSOURCELIST_NSources(newsourcelistp) +=
	    (newcollectionsourcelistsize - oldcollectionsourcelistsize);
	  TARGETSOURCELIST_SourceArray(newsourcelistp) =
	    (TARGETSOURCE **)
	    erealloc((void *) TARGETSOURCELIST_SourceArray(newsourcelistp),
		     TARGETSOURCELIST_NSources(newsourcelistp)
		     * sizeof(TARGETSOURCE *));
	  if (PROGRAM_ErrorNo == E_NULL) {
	    for (i = oldsourcelistsize;
		 i < TARGETSOURCELIST_NSources(newsourcelistp);
		 i++) {
	      TARGETSOURCELIST_Source(newsourcelistp, i) = NULL;
	    }
	  }
	}
	/* else no change in size, no reallocation required */
      }
      /* insert new contribution of collection at the location computed */

      if (PROGRAM_ErrorNo == E_NULL) {
	if (LocatedCollection
	&& (TARGETSOURCELIST_NSources(newsourcelistp) > oldsourcelistsize)) {
	  for (i = oldsourcelistsize - 1,
	       j = TARGETSOURCELIST_NSources(newsourcelistp) - 1;
	       (PROGRAM_ErrorNo == E_NULL) && (i > collectionend);
	       i--, j--) {
	    TARGETSOURCELIST_Source(newsourcelistp, j) =
	      TARGETSOURCELIST_Source(newsourcelistp, i);
	    TARGETSOURCELIST_Source(newsourcelistp, i) = NULL;
	  }
	}
	for (i = 0, j = InsertPoint;
	   (PROGRAM_ErrorNo == E_NULL) && (i < newcollectionsourcelistsize);
	     i++, j++) {
	  if (TARGETSOURCELIST_Source(newsourcelistp, j) != NULL)
	    TargetSource_Free(TARGETSOURCELIST_Source(newsourcelistp,
						      j));
	  TARGETSOURCELIST_Source(newsourcelistp, j) =
	    TargetSource(TARGETSOURCELIST_Source(collectionsourcelistp,
						 i));
	}
      }
      if (collectionsourcelistp != NULL)
	SourceList_Free(collectionsourcelistp);
    }
  }
  return (PROGRAM_ErrorNo == E_NULL) ? newsourcelistp : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/TargetDB/RCS/SourceList_Merge.c,v $ */
