/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/



%{


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: Preference_Read.y,v 1.6 1994/08/12 22:14:40 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Preference.h"

PREFERENCEDB *yyPreferenceDB;
extern int yylineno;

#define dbgprintf(x) /* fprintf x */

%}

%union
{
  int	ival;
  unsigned unsval;
  Boolean boolval;
  char	chrval;
  char *strval;
  STRINGARRAY *strarrval;
  STRINGSET *strsetval;
  SENTENCE *sentenceval;
}

%token <strval> UNKNOWNPREFNAME
%token <strval> INTRPREFNAME
%token <strval> UNSRPREFNAME
%token <strval> BOOLRPREFNAME
%token <strval> STRRPREFNAME
%token <strval> STRARRRPREFNAME
%token <strval> STRSETRPREFNAME
%token <strval> SENTENCERPREFNAME
%token <strval> INTGPREFNAME
%token <strval> UNSGPREFNAME
%token <strval> BOOLGPREFNAME
%token <strval> STRGPREFNAME
%token <strval> STRARRGPREFNAME
%token <strval> STRSETGPREFNAME
%token <strval> SENTENCEGPREFNAME
%token <ival> INTEGER
%token <unsval> UNSIGNED
%token <unsval> BOOLEAN
%token <strval> STRING
%token <strval> ITEM
%token <ival> WHITESPACE
%token <ival> COMMENT
%token <ival> NEWLINE
%token <ival> STRINGDELIMITER
%token <ival> SENTENCEDELIMITER

%type <ival> input
%type <ival> entry
%type <ival> Preference
%type <ival> RegPref
%type <ival> GlobalPref
%type <ival> IntRPref
%type <ival> UnsRPref
%type <ival> BoolRPref
%type <ival> StrRPref
%type <ival> StrArrRPref
%type <ival> StrSetRPref
%type <ival> SentenceRPref
%type <ival> IntGPref
%type <ival> UnsGPref
%type <ival> BoolGPref
%type <ival> StrGPref
%type <ival> StrArrGPref
%type <ival> StrSetGPref
%type <ival> SentenceGPref
%type <strarrval> StringArr
%type <strsetval> StringSet
%type <sentenceval> Sentence
%type <ival> OptionalWhiteSpace


%%	 /* rules */

input	 :	/* empty */
			{
			  $$ = 0;
			}
	|	input line
			{
			  $$ = $1;
			}
	;

line    :       NEWLINE | entry NEWLINE | entry ;


entry	:	OptionalWhiteSpace
			{
			  dbgprintf((stdout, "BLANK LINE\n"));
			  $$ = 0;
			}
	|	OptionalWhiteSpace COMMENT
			{
			  dbgprintf((stdout, "COMMENT\n"));
			  $$ = 0;
			}
	|	OptionalWhiteSpace Preference OptionalWhiteSpace
			{
			  dbgprintf((stdout, "Preference\n"));
			  $$ = $2;
			}
	;


Preference:	RegPref
			{
			  dbgprintf((stdout, "RegPref\n"));
			  $$ = $1;
			}
	|	GlobalPref
			{
			  dbgprintf((stdout, "GlobalPref\n"));
			  $$ = $1;
			}
	;


RegPref:	IntRPref
			{
			  dbgprintf((stdout, "IntRPref\n"));
			  $$ = $1;
			}
	|	UnsRPref
			{
			  dbgprintf((stdout, "UnsRPref\n"));
			  $$ = $1;
			}
	|	BoolRPref
			{
			  dbgprintf((stdout, "BoolRPref\n"));
			  $$ = $1;
			}
	|	StrRPref
			{
			  dbgprintf((stdout, "StrRPref\n"));
			  $$ = $1;
			}
	|	StrArrRPref
			{
			  dbgprintf((stdout, "StrArrRPref\n"));
			  $$ = $1;
			}
	|	StrSetRPref
			{
			  dbgprintf((stdout, "StrSetRPref\n"));
			  $$ = $1;
			}
	|	SentenceRPref
			{
			  dbgprintf((stdout, "SentenceRPref\n"));
			  $$ = $1;
			}
	;


IntRPref:	INTRPREFNAME WHITESPACE ITEM WHITESPACE INTEGER
			{
			  dbgprintf((stdout, "INTRPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetInt(yyPreferenceDB,
						  $3, $1, $5);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


UnsRPref:	UNSRPREFNAME WHITESPACE ITEM WHITESPACE UNSIGNED
			{
			  dbgprintf((stdout, "UNSRPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetUnsigned(yyPreferenceDB,
						       $3, $1, $5);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


BoolRPref:	BOOLRPREFNAME WHITESPACE ITEM WHITESPACE BOOLEAN
			{
			  dbgprintf((stdout, "BOOLRPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetBoolean(yyPreferenceDB,
						      $3, $1, $5);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


StrRPref:	STRRPREFNAME WHITESPACE ITEM WHITESPACE STRING
			{
			  dbgprintf((stdout, "STRRPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetString(yyPreferenceDB,
						     $3, $1, $5);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


StrArrRPref:	STRARRRPREFNAME WHITESPACE ITEM WHITESPACE StringArr
			{
			  dbgprintf((stdout, "STRARRRPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetStringArray(yyPreferenceDB,
							  $3, $1, $5);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


StrSetRPref:	STRSETRPREFNAME WHITESPACE ITEM WHITESPACE StringSet
			{
			  dbgprintf((stdout, "STRSETRPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetStringSet(yyPreferenceDB,
							$3, $1, $5);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


SentenceRPref:	SENTENCERPREFNAME WHITESPACE ITEM SENTENCEDELIMITER Sentence
			{
			  dbgprintf((stdout, "SENTENCERPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetSentence(yyPreferenceDB,
						       $3, $1, $5);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


GlobalPref:	IntGPref
			{
			  dbgprintf((stdout, "IntGPref\n"));
			  $$ = $1;
			}
	|       UnsGPref
			{
			  dbgprintf((stdout, "UnsGPref\n"));
			  $$ = $1;
			}
	|       BoolGPref
			{
			  dbgprintf((stdout, "BoolGPref\n"));
			  $$ = $1;
			}
	|       StrGPref
			{
			  dbgprintf((stdout, "StrGPref\n"));
			  $$ = $1;
			}
	|       StrArrGPref
			{
			  dbgprintf((stdout, "StrArrGPref\n"));
			  $$ = $1;
			}
	|       StrSetGPref
			{
			  dbgprintf((stdout, "StrSetGPref\n"));
			  $$ = $1;
			}
	|	SentenceGPref
			{
			  dbgprintf((stdout, "SentenceGPref\n"));
			  $$ = $1;
			}
        ;


IntGPref:	INTGPREFNAME WHITESPACE INTEGER
			{
			  dbgprintf((stdout, "INTGPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetInt(yyPreferenceDB,
						  NULL, $1, $3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


UnsGPref:	UNSGPREFNAME WHITESPACE UNSIGNED
			{
			  dbgprintf((stdout, "UNSGPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetUnsigned(yyPreferenceDB,
						       NULL, $1, $3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


BoolGPref:	BOOLGPREFNAME WHITESPACE BOOLEAN
			{
			  dbgprintf((stdout, "BOOLGPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetBoolean(yyPreferenceDB,
						      NULL, $1, $3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


StrGPref:	STRGPREFNAME WHITESPACE STRING
			{
			  dbgprintf((stdout, "STRGPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetString(yyPreferenceDB,
						     NULL, $1, $3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


StrArrGPref:	STRARRGPREFNAME WHITESPACE StringArr
			{
			  dbgprintf((stdout, "STRARRGPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetStringArray(yyPreferenceDB,
							  NULL, $1, $3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


StrSetGPref:	STRSETGPREFNAME WHITESPACE StringSet
			{
			  dbgprintf((stdout, "STRSETGPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetStringSet(yyPreferenceDB,
							NULL, $1, $3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


SentenceGPref:	SENTENCEGPREFNAME SENTENCEDELIMITER Sentence
			{
			  dbgprintf((stdout, "SENTENCEGPREFNAME\n"));
			  if (PROGRAM_ErrorNo == E_NULL)
			    yyPreferenceDB
			      = Preference_SetSentence(yyPreferenceDB,
						       NULL, $1, $3);
			  $$ = (PROGRAM_ErrorNo == E_NULL) ? 0 : -1;
			}
	;


StringArr:	STRING
			{
			  dbgprintf((stdout, "STRING\n"));
			  $$ = StringArray_AppendString(NULL, $1);
			}
	|	StringArr STRINGDELIMITER STRING
			{
			  dbgprintf((stdout, "StringArr\n"));
			  $$ = StringArray_AppendString($1, $3);
			}
	;

StringSet:	STRING
			{
			  dbgprintf((stdout, "STRING\n"));
			  $$ = StringSet_AddString(NULL, $1);
			}
	|	StringSet STRINGDELIMITER STRING
			{
			  dbgprintf((stdout, "StringSet\n"));
			  $$ = StringSet_AddString($1, $3);
			}
	;

Sentence:	STRING
			{
			  dbgprintf((stdout, "STRING\n"));
			  $$ = StringArray_AppendString(NULL, $1);
			}
	|	Sentence SENTENCEDELIMITER STRING
			{
			  dbgprintf((stdout, "Sentence\n"));
			  $$ = StringArray_AppendString($1, $3);
			}
        ;



OptionalWhiteSpace: /* empty */
			{ $$ = 0; }
	|	WHITESPACE
			{ $$ = 1; }
	;


%%

yyerror(str)
     char *str;
{
  FatalError(E_PREFERENCEPARSE, 
	     "Error parsing depot preferences file: %s: line %d\n",
	     str, yylineno);
}


yywrap()
{ return 1; }


PREFERENCEDB *PreferenceDB_Read(fp)
     FILE *fp;
{
  extern FILE *yyin;

  yyPreferenceDB = (PREFERENCEDB *)emalloc(sizeof(PREFERENCEDB));
  if (PROGRAM_ErrorNo == E_NULL)
    *yyPreferenceDB = PreferenceDB_InitializeSetup();
  yyin = fp;

  yylineno = 1;
  yyclearin;
  yyparseinit();

  if ((PROGRAM_ErrorNo == E_NULL) && (yyparse() < 0))
    {
      FatalError(E_PREFERENCEPARSE, "Error parsing preference file\n");
    }

  return (PROGRAM_ErrorNo == E_NULL) ? yyPreferenceDB : NULL;
}
/* $Source: /afs/andrew/system/src/local/depot2/016/src/lib/Preference/RCS/Preference_Read.y,v $ */
