/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifndef _DEPOT_PREFERENCE_H
#define _DEPOT_PREFERENCE_H

/* $Id: Preference.h,v 1.10 1994/09/30 20:48:09 ww0r Exp $ 
 *
 * Author: Sohan C. Ramakrishna Pillai
 */

typedef struct PREFERENCE {
  int optionid;
  unsigned short type;
  char *operand;
  union {
    int ival;
    unsigned int uval;
    Boolean boolval;
    char *strval;
    STRINGARRAY *strarrval;
  } value;
} PREFERENCE;

typedef PREFERENCE ***PREFERENCEDB;

#define PREFERENCE_OptionID(pp) ((pp)->optionid)
#define PREFERENCE_Type(pp) ((pp)->type)
#define PREFERENCE_Operand(pp) ((pp)->operand)
#define PREFERENCE_IVal(pp) ((pp)->value.ival)
#define PREFERENCE_UVal(pp) ((pp)->value.uval)
#define PREFERENCE_BoolVal(pp) ((pp)->value.boolval)
#define PREFERENCE_StrVal(pp) ((pp)->value.strval)
#define PREFERENCE_StrArrVal(pp) ((pp)->value.strarrval)
#define PREFERENCE_StrSetVal(pp) ((pp)->value.strarrval)
#define PREFERENCE_SentenceVal(pp) ((pp)->value.strarrval)

#define PREF_WILDITEM	"*"
#define PREF_QUOTECHAR	'\\'
#define PREF_STRINGARRAYDELIM	','
#define PREF_SENTENCEDELIM	' '

#define PREF_UNKNOWN	0x0000
#define PREF_INTEGER	0x0010
#define PREF_UNSIGNED	0x0020
#define PREF_BOOLEAN	0x0040
#define PREF_STRING	0x0080
#define PREF_STRINGARRAY 0x0100
#define PREF_STRINGSET	0x0200
#define PREF_SENTENCE	0x0400

#define PREF_REGULAR	0x0001
#define PREF_GLOBAL	0x0002
#define PREF_COMMAND    0x0004
#define PREF_FILTER     0x0008

#define PREF_INTERNAL   0x1000

#define PREFDEFAULT_INTEGER	-1
#define PREFDEFAULT_UNSIGNED	0
#define PREFDEFAULT_BOOLEAN	FALSE
#define PREFDEFAULT_STRING	NULL
#define PREFDEFAULT_STRINGARRAY	NULL
#define PREFDEFAULT_STRINGSET	NULL
#define PREFDEFAULT_SENTENCE	NULL

#define Preference_DefaultValue(x) \
  (((x) & PREF_INTEGER) ? (int) PREFDEFAULT_INTEGER : \
   ((x) & PREF_UNSIGNED) ? (int) PREFDEFAULT_UNSIGNED : \
   ((x) & PREF_BOOLEAN) ? (int) PREFDEFAULT_BOOLEAN : \
   ((x) & PREF_STRING) ? (int) PREFDEFAULT_STRING : \
   ((x) & PREF_STRINGARRAY) ? (int) PREFDEFAULT_STRINGARRAY : \
   ((x) & PREF_STRINGSET) ? (int) PREFDEFAULT_STRINGSET : \
   ((x) & PREF_SENTENCE) ? (int) PREFDEFAULT_SENTENCE : \
   0)


#define Preference_HashTableSize	1024

extern char *PrefInternalPref;
extern char *PrefInternalCmdList;

extern PREFERENCEDB *PreferenceDB_Read();
extern int PreferenceDB_Write();
extern PREFERENCE *Preference_Lookup();
extern PREFERENCEDB PreferenceDB_InitializeSetup();

extern PREFERENCEDB *Preference_SetInt();
extern PREFERENCEDB *Preference_SetUnsigned();
extern PREFERENCEDB *Preference_SetBoolean();
extern PREFERENCEDB *Preference_SetString();
extern PREFERENCEDB *Preference_SetStringArray();
extern PREFERENCEDB *Preference_SetStringSet();
extern PREFERENCEDB *Preference_SetSentence();

extern int Preference_GetInt();
extern unsigned Preference_GetUnsigned();
extern Boolean Preference_GetBoolean();
extern char *Preference_GetString();
extern STRINGARRAY *Preference_GetStringArray();
extern STRINGSET *Preference_GetStringSet();
extern SENTENCE *Preference_GetSentence();

extern STRINGSET   *Preference_GetCollectionNameList();
extern STRINGSET   *Preference_GetSearchPathList();
extern STRINGARRAY *Preference_GetSearchPathEntry();
extern STRINGSET   *Preference_GetOwnerNamesToSet();
extern STRINGSET   *Preference_GetGroupNamesToSet();
extern STRINGSET   *Preference_GetModeMasksToSet();
extern STRINGSET   *Preference_GetSetUIDNamesToSet();
extern STRINGSET   *Preference_GetSetGIDNamesToSet();
extern STRINGSET   *Preference_GetTargetCommandList();

extern Boolean PreferenceDB_Override();
extern char *PreferenceDB_CollectionInstallMethod();

extern PREFERENCE ***Preference_Diff();

extern unsigned short Preference_Type();
extern int Preference_OptionID();
extern char *Preference_OptionName();
extern int PreferenceArray_Size();
extern int Preference_Comparator();

#define PREFERENCE_Option(pp) (Preference_OptionName(PREFERENCE_OptionID(pp)))

/* Preference_Depot.c */
extern Boolean Preference_Universal();
extern Boolean Preference_CollectionOperand();
extern Boolean Preference_TargetOperand();
extern Boolean Preference_CommandOperand();
extern Boolean Preference_CollectionValue();
extern Boolean Preference_TargetValue();
extern STRINGSET *PreferenceDiff_GetChangedTargets();
extern STRINGSET *PreferenceDiff_GetChangedCollections();
extern STRINGSET *PreferenceDiff_GetChangedCommands();

#endif /* _DEPOT_PREFERENCE_H */
/* $Source: /afs/andrew/system/src/local/depot2/013/src/lib/Preference/RCS/Preference.h,v $ */
