/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: HintDB_SetPathPrefix.c,v 1.3 1994/08/12 18:01:34 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"
#include "FileSystemImage.h"
#include "Hint.h"

/*
 * HINTDB HintDB_SetPathPrefix(hintdb, pathprefix)
 *	HINTDB hintdb;
 *	char *pathprefix;
 * prefixes each path in the hint database hintdb with the specified pathprefix.
 * It then returns the updated hint database, or NULL if an error occurs.
 */
HINTDB HintDB_SetPathPrefix(hintdb, pathprefix)
     HINTDB hintdb;
     char *pathprefix;
{
  HINTDB newdb;
  char *newpath;

  register HINTDB hp;

  newdb = hintdb;
  if ((newdb != NULL) && (pathprefix != NULL) && (pathprefix[0] != '\0'))
    {
      for (hp = newdb;
	   (PROGRAM_ErrorNo == E_NULL) && (*hp != NULL);
	   hp++)
	{
	  if (*hp != NULL)
	    {
	      if ((strcmp(HINT_PathName(*hp), "/") == 0)
		  || (strcmp(HINT_PathName(*hp), ".") == 0))
		{
		  (void)free((void *)HINT_PathName(*hp));
		  HINT_PathName(*hp) = String(pathprefix, strlen(pathprefix));
		}
	      else
		{
		  newpath = (char *)emalloc(strlen(pathprefix)
					    + 1		/* for the '/' */
					    + strlen(HINT_PathName(*hp))
					    + 1);
		  if (PROGRAM_ErrorNo == E_NULL)
		    {
		      (void)sprintf(newpath, "%s/%s",
				    pathprefix, HINT_PathName(*hp));
		      (void)free((void *)HINT_PathName(*hp));
		      HINT_PathName(*hp) = newpath;
		    }
		}
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newdb : NULL;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Hint/RCS/HintDB_SetPathPrefix.c,v $ */
