/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: File_SetStatus.c,v 1.8 1994/11/14 00:39:56 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */


#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"

int 
File_SetStatus(path, status, flags)
     char *path;
     FILESTAT *status;
     unsigned flags;
{
#ifdef HAVE_UTIMES
  struct timeval modtime[2];
#else /* HAVE_UTIME */
  time_t modtime[2];
#endif /* HAVE_UTIMES */
  char *moddate;
  uid_t uid;
  gid_t gid;
  FILESTAT statusbuffer;
  mode_t mode;

  if (flags & (FSTAT_SETUID | FSTAT_SETGID | FSTAT_OWNER | FSTAT_GROUP)) {
    /* set uid and/or gid */
    uid =
      (flags & (FSTAT_SETUID | FSTAT_OWNER)) ? (uid_t) (FILESTAT_Uid(status)) : -1;
    gid =
      (flags & (FSTAT_SETGID | FSTAT_GROUP)) ? (gid_t) (FILESTAT_Gid(status)) : -1;
    Filtered_Message(PROGRAM_Verbose, "CHOWN %s %d %d\n", path, uid, gid);
    if (chown(path, (uid_t) uid, (uid_t) gid) < 0) {
      FatalError(E_CHOWNFAILED,
		 "CHOWN %s %d %d failed: %s\n",
		 path, uid, gid, strerror(errno));
      return -1;
    }
  }
  if (flags & (FSTAT_MODE | FSTAT_SETUID | FSTAT_SETGID)) {
    if (flags & FSTAT_MODE) {
      mode = FILESTAT_Mode(status);
    } else {			/* flags & (FSTAT_SETUID|FSTAT_SETGID) */
      File_GetStatus(path, &statusbuffer, FALSE /* followlinks */ );
      mode = FILESTAT_Mode(&statusbuffer);
    }
    if (flags & FSTAT_SETUID) {
      mode |= FSTATMODE_SETUID;
    }
    if (flags & FSTAT_SETGID) {
      mode |= FSTATMODE_SETGID;
    }
    /* set permissions */
    Filtered_Message(PROGRAM_Verbose, "CHMOD %s %o\n", path, mode);
    if (chmod(path, mode) < 0) {
      FatalError(E_CHMODFAILED,
		 "CHMOD %s %o failed: %s\n", path, mode, strerror(errno));
      return -1;
    }
  }
  if (flags & FSTAT_MTIME) {
    /* set modification time */
#ifdef HAVE_UTIMES
    modtime[0].tv_sec = modtime[1].tv_sec = (time_t) FILESTAT_MTime(status);
    modtime[0].tv_usec = modtime[1].tv_usec = 0;
    moddate = ctime((time_t *) & (modtime[1].tv_sec));
    moddate[24] = '\0';
    Filtered_Message(PROGRAM_Verbose, "UTIMES %s %s\n", path, moddate);

    if (utimes(path, modtime) < 0) {
      FatalError(E_UTIMESFAILED,
		 "UTIME %s %s failed: %s\n",
		 path, moddate, strerror(errno));
      return -1;
    }
#else /* HAVE_UTIMES */
    modtime[0] = modtime[1] = (time_t) FILESTAT_MTime(status);
    moddate = ctime(&modtime[1]);
    moddate[24] = '\0';
    Filtered_Message(PROGRAM_Verbose, "UTIME %s %s\n", path, moddate);

    if (utime(path, modtime) < 0) {
      FatalError(E_UTIMEFAILED,
		 "UTIME %s %s failed: %s\n",
		 path, moddate, strerror(errno));
      return -1;
    }
#endif /* HAVE_UTIMES */
  }
  return 0;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/016/src/lib/FileOps/RCS/File_SetStatus.c,v $ */
