#if !defined(SABER) && !defined(LINT)
static char rcs_id[] = "$Id: File_Copy.c,v 2.1 1995/11/14 20:36:37 wcw Exp $";
#endif /* LINT && SABER */

#include "depotlib.h"
#include "util.h"
#include "DepotErrorCodes.h"
#include "File.h"

#define BUFCP_SIZE 16384
static int 
cp(src, dst)
  char *src, *dst;
{
  int fd_src, fd_dst;
  int rc = 0;
  char buf[BUFCP_SIZE];
  size_t nr; 
 
  if ((fd_src = open(src, O_RDONLY)) < 0) {
    FatalError(E_OPENFAILED, "Unable to open %s: %s\n", 
	       src, strerror(errno));
    return -1;
  }

  if ((fd_dst = open(dst, O_RDWR|O_CREAT|O_TRUNC, 0600)) < 0) {
    FatalError(E_OPENFAILED, "Unable to open %s: %s\n", 
	       dst, strerror(errno));
    rc = -1;
    goto close_source;
  }

  while ((nr = read(fd_src, buf, BUFCP_SIZE)) > 0) {
    if (write(fd_dst, buf, nr) != nr) {
      FatalError(E_WRITEFAILED, "Unable to write %d bytes to %s: %s\n", 
		 nr, dst, strerror(errno));
      return -1;
    }
  }
  /* nr at this point will either be 0; EOF or -1 error so we can 
   * just return that */
  if ((rc = nr) < 0) { /* assignment is on purpose! */
    FatalError(E_READFAILED, "Unable to read file %s: %s",
	       src, strerror(errno));
  }
  
  if (close(fd_dst) < 0) {
    FatalError(E_CLOSEFAILED, "Unable to close destination file %s: %s\n",
	       dst, strerror(errno));
  }
  
  close_source:
  /* don't make this close a fatal error since the worst that can happen is
   * a fd leak */
  if (close(fd_src) < 0) { 
    fprintf(stderr,"WARNING: Unable to close source file %s: %s\n",
	    src, strerror(errno));
  }

  return rc;
}


int 
File_Copy(from, to, status, flags)
     char *from, *to;
     FILESTAT *status;
     unsigned flags;
{
  FILESTAT statbuf;
  char temp[MAXPATHLEN];

  (void) sprintf(temp, "%s.NEW", to);
  Filtered_Message(PROGRAM_Verbose, "COPY %s %s\n", from, temp);

  if (PROGRAM_ErrorNo == E_NULL) {
    if (cp(from, temp) < 0) {
      FatalError(E_COPYFAILED,
		 "Could not copy %s to %s:%s\n", from, temp,
		 strerror(errno));
    }
  }
  if ((PROGRAM_ErrorNo == E_NULL) && (flags != FSTAT_NULL)) {
    if (status == NULL) {
      status = &statbuf;
      if (File_GetStatus(from, status, FALSE /* !followlinks */ ) < 0) {
	FatalError(E_GETSTATUSFAILED,
		   "Could not get status of file %s\n", from);
      }
    }
    if (PROGRAM_ErrorNo == E_NULL) {
      /* set modes etc. */
      if (File_SetStatus(temp, status, flags) < 0) {
	FatalError(E_SETSTATUSFAILED,
		   "Could not set status of file %s\n", temp);
      }
    }
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    if (File_Move(temp, to) < 0) { 
      FatalError(E_RENAMEFAILED,
		   "\nCOPY %s %s : Could not move %s to %s: %s\n",
		   from, to, temp, to, strerror(errno));
    }
  }
  return ((PROGRAM_ErrorNo == E_NULL) ? 0 : -1);
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/022/src/lib/FileOps/RCS/File_Copy.c,v $ */
