import { useId } from 'react';

export const DevicePageNavigationIcon = () => {
  const id = useId();
  return (
    <svg
      width={24}
      height={25}
      viewBox="0 0 24 25"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M14 0.5H20C22.2091 0.5 24 2.29097 24 4.50025V20.5013C24 22.7105 22.2091 24.5015 20 24.5015H14C11.7909 24.5015 10 22.7105 10 20.5013V4.50025C10 2.29097 11.7909 0.5 14 0.5ZM14 2.50013C12.8954 2.50013 12 3.39561 12 4.50025V20.5013C12 21.6059 12.8954 22.5014 14 22.5014H20C21.1046 22.5014 22 21.6059 22 20.5013V4.50025C22 3.39561 21.1046 2.50013 20 2.50013H14Z"
        fill="#0C8CE0"
      />
      <mask
        id={id}
        style={{
          maskType: 'alpha',
        }}
        maskUnits="userSpaceOnUse"
        x={0}
        y={0}
        width={24}
        height={20}
      >
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M5.62614 2.50013C4.66484 2.50141 3.74326 2.88388 3.06349 3.56368C2.38373 4.24349 2.00129 5.16513 2 6.12649V13.8127C2.00129 14.7738 2.38362 15.6952 3.0632 16.3748C3.74266 17.0543 4.66378 17.4366 5.62463 17.4381C5.62513 17.4381 5.62563 17.4381 5.62613 17.4381H18.3729C18.3734 17.4381 18.3739 17.4381 18.3744 17.4381C19.3354 17.4366 20.2567 17.0543 20.9363 16.3747C21.6159 15.6951 21.9985 14.7738 22 13.8127C22 13.8122 22 13.8118 22 13.8113V6.12748C22 6.12698 22 6.12648 22 6.12598C21.9986 5.1648 21.6162 4.24337 20.9365 3.56368C20.2567 2.88388 19.3352 2.50141 18.3739 2.50013H5.62614ZM18.375 0.5H5.625C4.13365 0.501588 2.70383 1.09477 1.64928 2.14938C0.594731 3.204 0.00158824 4.6339 0 6.12535V13.8138C0.00158824 15.305 0.594625 16.7347 1.64899 17.7891C2.70335 18.8435 4.13291 19.4366 5.624 19.4382H18.375C19.8662 19.4366 21.2959 18.8436 22.3504 17.7892C23.4049 16.7348 23.9982 15.3051 24 13.8138V6.12535C23.9984 4.6339 23.4053 3.204 22.3507 2.14938C21.2962 1.09477 19.8664 0.501588 18.375 0.5Z"
          fill="#0C8CE0"
        />
      </mask>
      <g mask={`url(#${id})`}>
        <rect
          width={10}
          height={23.0014}
          transform="matrix(-1 0 0 1 9 -1.5)"
          fill="#0C8CE0"
        />
      </g>
      <path
        d="M4 23.5013C4 22.9491 4.44772 22.5013 5 22.5013H9V24.5013H5C4.44772 24.5013 4 24.0536 4 23.5013Z"
        fill="#0C8CE0"
      />
      <circle cx={17} cy={19.5011} r={1} fill="#0C8CE0" />
    </svg>
  );
};
