FROM ghcr.io/webassembly/wasi-sdk:wasi-sdk-25 as build

# Install dependencies
RUN set -x; \
    apt-get update && \
    apt-get install -y curl \
                       git \
                       nasm \
                       pkg-config \
                       cmake \
                       wget

# Copy over
# scripts.
COPY * /

# Run dep build scripts
RUN /install_binaryen.sh
RUN /install_wabt.sh
RUN /build_zlib.sh
RUN /build_png.sh
RUN /build_x264.sh
RUN /build_webp.sh
RUN /build_mp3.sh
RUN /build_opus.sh
RUN /build_vpx.sh
RUN /build_av1.sh

# Release flag
ARG RELEASE

# Perform the build!
RUN RELEASE=${RELEASE} \
    /build_ffmpeg.sh
