{
  perSystem =
    {
      config,
      pkgs,
      lib,
      ...
    }:
    let
      nativeBuildInputs = [
        pkgs.pkg-config
        pkgs.installShellFiles # includes installShellCompletion
      ];
      buildInputs = [
        pkgs.openssl
      ];
      env = {
        # this approach should be favored over LD_LIBRARY_PATH as it is more precise
        RUSTFLAGS = "-C link-args=-Wl,-rpath,${lib.makeLibraryPath buildInputs}";
      };
      mkDerivationWith =
        extraAttrs: lib.recursiveUpdate extraAttrs { inherit nativeBuildInputs buildInputs; };
      cfgWith = extraDrvAttrs: {
        inherit env;
        mkDerivation = mkDerivationWith extraDrvAttrs;
      };
    in
    {
      nci = {
        toolchainConfig = ./../../rust-toolchain.toml;
        projects.codeberg-cli.path = ./../..;

        crates.codeberg-cli = {
          depsDrvConfig = cfgWith { };
          drvConfig = cfgWith {
            # allow for auto completion
            postInstall = lib.optionalString (pkgs.stdenv.buildPlatform.canExecute pkgs.stdenv.hostPlatform) ''
              installShellCompletion --cmd berg \
                --bash <($out/bin/berg completion bash) \
                --fish <($out/bin/berg completion fish) \
                --zsh <($out/bin/berg completion zsh)
            '';

            meta = {
              description = "CLI Tool for Codeberg similar to gh and glab";
              homepage = "https://codeberg.org/Aviac/codeberg-cli";
              license = [ lib.licenses.agpl3Plus ];
              maintainers = [ lib.maintainers.robwalt ];
              mainProgram = "berg";
            };
          };
        };
      };

      packages.berg = config.nci.outputs.codeberg-cli.packages.release;
    };
}
