// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

//go:build go1.23

package asset

import (
	"iter"

	assetpb "cloud.google.com/go/asset/apiv1/assetpb"
	"github.com/googleapis/gax-go/v2/iterator"
)

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AnalyzeOrgPoliciesResponse_OrgPolicyResultIterator) All() iter.Seq2[*assetpb.AnalyzeOrgPoliciesResponse_OrgPolicyResult, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAssetIterator) All() iter.Seq2[*assetpb.AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainerIterator) All() iter.Seq2[*assetpb.AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AssetIterator) All() iter.Seq2[*assetpb.Asset, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *IamPolicySearchResultIterator) All() iter.Seq2[*assetpb.IamPolicySearchResult, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ResourceSearchResultIterator) All() iter.Seq2[*assetpb.ResourceSearchResult, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *SavedQueryIterator) All() iter.Seq2[*assetpb.SavedQuery, error] {
	return iterator.RangeAdapter(it.Next)
}
