/*

	$Id: ipmon2ipstat.c,v 1.5 2000/01/18 13:36:44 tron Exp $

*/

#include <sys/types.h>
#include <netinet/in.h>

#include <ctype.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "iprecord.h"

#define TRUE  1
#define FALSE 0

char *Progname;

static void Usage(void)

{
 (void)fprintf(stderr,
               "Usage: %s [-s] logfilefile [logfilefile ...]\n",
               Progname);
 exit(EXIT_FAILURE);
}

static char *GetWord(char **Line,int Index)

{
 char *First,*Ptr;

 First=NULL;
 while (Index>=0)
  {
   if (*Line==NULL) break;

   Ptr=*Line;
   while (isspace(*Ptr)) Ptr++;
   if (*Ptr=='\0')
    {
     *Line=NULL;
     break;
    }
   if (Index--==0) First=Ptr;

   while (*Ptr!='\0')
    if (isspace(*Ptr))
     {
      *Ptr++='\0';
      break;
     }
    else Ptr++;

   *Line=Ptr;
  }

 return First;
}

static char *ParseIP(char *Ptr,struct in_addr *TheIP)

{
 u_int32_t MyIP;
 char *EndPtr;
 int Index;

 MyIP=(u_int32_t)strtol(Ptr,&EndPtr,10);
 if (Ptr==EndPtr) return NULL;

 for (Index=0, Ptr=EndPtr; Index<3; Index++, Ptr=EndPtr)
  if (*Ptr++!='.') return NULL;
  else
   {
    MyIP=(MyIP<<8)|(u_int32_t)strtol(Ptr,&EndPtr,10);
    if (Ptr==EndPtr) return NULL;
   }

 TheIP->s_addr=htonl(MyIP);
 return Ptr;
}

static int GetProtoNum(char *Name)

{
 struct protoent *Proto;

 if (strcmp(Name,"tcp")==0) return IPPROTO_TCP;
 if (strcmp(Name,"udp")==0) return IPPROTO_UDP;
 if (strcmp(Name,"icmp")==0) return IPPROTO_ICMP;

 if ((*Name>='0')&&(*Name<='9')) return atoi(Name);

 return ((Proto=getprotobyname(Name))==NULL)?0:Proto->p_proto;
}

static void ReadLogfile(FILE *In,int Offset)

{
 IPRecord IR;
 char Buffer[1024],*Line,*Ptr;
 int Port;

 while ((Line=fgets(Buffer,sizeof(Buffer),In))!=NULL)
  {
   if ((Ptr=GetWord(&Line,Offset))==NULL) continue;

   if ((Ptr=ParseIP(Ptr,&IR.ir_SrcAddr))==NULL) continue;
   if (*Ptr==',')
    {
     Port=atoi(Ptr+1);
     if ((Port>0)&&(Port<65536)) IR.ir_SrcPort=Port;
    }
   else IR.ir_SrcPort=0;

   if ((Ptr=GetWord(&Line,0))==NULL) continue;
#if 0
   (void)fputs(Ptr,stderr);
   (void)fputc('\n',stderr);
#endif
   if (strcmp(Ptr,"->")!=0) continue;
   if ((Ptr=GetWord(&Line,0))==NULL) continue;

   if ((Ptr=ParseIP(Ptr,&IR.ir_DstAddr))==NULL) continue;
   if (*Ptr==',')
    {
     Port=atoi(Ptr+1);
     if ((Port>0)&&(Port<65536)) IR.ir_DstPort=Port;
    }
   else IR.ir_DstPort=0;

   if ((Ptr=GetWord(&Line,0))==NULL) continue;
   if (strcmp(Ptr,"PR")!=0) continue;
   if ((Ptr=GetWord(&Line,0))==NULL) continue;

   IR.ir_Proto=GetProtoNum(Ptr);
   if ((IR.ir_Proto!=IPPROTO_TCP)&&(IR.ir_Proto!=IPPROTO_UDP))
    {
     IR.ir_SrcPort=0;
     IR.ir_DstPort=0;
    }

   if ((Ptr=GetWord(&Line,0))==NULL) continue;
   if (strcmp(Ptr,"len")!=0) continue;
   if ((Ptr=GetWord(&Line,1))==NULL) continue;

   if ((IR.ir_Bytes=atoi(Ptr))<=0) continue;
   IR.ir_Packets=1;

   (void)fwrite(&IR,sizeof(IPRecord),1,stdout);
  }
}

int main(int argc,char **argv)

{
 int Offset,Opt,Index;

 Progname=argv[0];

 Offset=5;
 while ((Opt=getopt(argc,argv,"s"))!=-1)
  switch (Opt)
   {
    case 's':
     Offset=8;
     break;
    default:
     Usage();
   }
 argc-=optind;
 argv+=optind;

 if (argc<1) Usage();

 for (Index=0; Index<argc; Index++)
  if (strcmp(argv[Index],"-")==0) ReadLogfile(stdin,Offset);
  else
   {
    FILE *In;

    if ((In=fopen(argv[Index],"r"))==NULL)
     {
      (void)fprintf(stderr,
                    "%s: unable to open data file \"%s\".\n",
                    Progname,argv[Index]);
      return EXIT_FAILURE;
     }

    ReadLogfile(In,Offset);

    (void)fclose(In);
   }

 return EXIT_SUCCESS;
}
