/*
 * nodes.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "nodes";

/*
** GLOBALS
*/

	static long undefined[] = {1023};
long G_nodes_TREE_NR0B = 0;
value G_nodes_TREE_NR0 = &G_nodes_TREE_NR0B;
long G_nodes_LINENRS_NR1A = 1;
value G_nodes_LINENRS_NR1 = &G_nodes_LINENRS_NR1A;
long G_nodes_ARCS_NR2B = 0;
value G_nodes_ARCS_NR2 = &G_nodes_ARCS_NR2B;
long G_nodes_NR_OF_NODES_NR3 = 0;
long G_nodes_NODE_NR2896[] = {Tag(1,11)};
long G_nodes_ARCS_NR2897[] = {Tag(1,0)};
long G_nodes_TEXT_NR2900[] = {Tag(1,T_TEXT),1,(long)"("};
long G_nodes_TEXT_NR2901[] = {Tag(1,T_TEXT),1,(long)")"};
long G_nodes_TEXT_NR2902[] = {Tag(1,T_TEXT),1,(long)" "};
long G_nodes_TEXT_NR2903[] = {Tag(1,T_TEXT),1,(long)"|"};
long G_nodes_TEXT_NR2904[] = {Tag(1,T_TEXT),1,(long)"'"};
long G_nodes_TEXT_NR2905[] = {Tag(1,T_TEXT),1,(long)"!"};
long G_nodes_TEXT_NR2906[] = {Tag(1,T_TEXT),1,(long)"{"};
long G_nodes_TEXT_NR2907[] = {Tag(1,T_TEXT),1,(long)"}"};

/*
** ATTACH/DETACH/EQUAL
*/
/****ARCS(nodes)****/

int EQ_Mnodes_T3(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return (Part(x,1) == Part(y,1));
       case 2:
         return (Part(x,1) == Part(y,1));
       case 3:
         return (Part(x,1) == Part(y,1))&&(Part(x,2) == Part(y,2));
    };
  return 0;
}

int W_Mnodes_T3(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("none ");
       case 1:
WRITE("on ");
WRITE("succeed ");
WRITE("goto ");
W_INT(Part(x,1));
WRITE(" ");
       case 2:
WRITE("on ");
WRITE("failure ");
WRITE("goto ");
W_INT(Part(x,1));
WRITE(" ");
       case 3:
WRITE("on ");
WRITE("succeed ");
WRITE("goto ");
W_INT(Part(x,1));
WRITE(" ");
WRITE("and ");
WRITE("on ");
WRITE("failure ");
WRITE("goto ");
W_INT(Part(x,2));
WRITE(" ");
    };
  return 0;
}

int XD_Mnodes_T3(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,2);
            break;
          case 2:
            Free(x,2);
            break;
          case 3:
            Free(x,3);
            break;
    };
}

int D_Mnodes_T3(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mnodes_T3(x);
}

/****EXPRESSION(nodes)****/

int EQ_Mnodes_T6(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mnodes_T6(Part(x,1),Part(y,1))&&EQ_Mnodes_T6(Part(x,2),Part(y,2));
       case 1:
         return EQ_Mnodes_T7(Part(x,1),Part(y,1))&&EQ_Mnodes_T6(Part(x,2),Part(y,2));
       case 2:
         return 1;
    };
  return 0;
}

int W_Mnodes_T6(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Mnodes_T6(Part(x,1));
WRITE(" ");
WRITE("bar ");
W_Mnodes_T6(Part(x,2));
WRITE(" ");
       case 1:
W_Mnodes_T7(Part(x,1));
WRITE(" ");
W_Mnodes_T6(Part(x,2));
WRITE(" ");
       case 2:
WRITE("end ");
    };
  return 0;
}

int XD_Mnodes_T6(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mnodes_T6(Part(x,1));
D_Mnodes_T6(Part(x,2));
            Free(x,3);
            break;
          case 1:
D_Mnodes_T7(Part(x,1));
D_Mnodes_T6(Part(x,2));
            Free(x,3);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mnodes_T6(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mnodes_T6(x);
}

/****SUBEXPRESSION(nodes)****/

int EQ_Mnodes_T7(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mcode_T13(Part(x,1),Part(y,1))&&EQ_Mnodes_T7(Part(x,2),Part(y,2));
       case 1:
         return EQ_Mnodes_T7(Part(x,1),Part(y,1))&&EQ_Mcode_T12(Part(x,2),Part(y,2))&&EQ_Mnodes_T7(Part(x,3),Part(y,3));
       case 2:
         return EQ_Mnodes_T6(Part(x,1),Part(y,1));
       case 3:
         return EQ_Mnodes_T11(Part(x,1),Part(y,1));
       case 4:
         return (Part(x,1) == Part(y,1));
       case 5:
         return (Part(x,1) == Part(y,1));
       case 6:
         return EQ_TEXT(Part(x,1),Part(y,1));
    };
  return 0;
}

int W_Mnodes_T7(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Mcode_T13(Part(x,1));
WRITE(" ");
W_Mnodes_T7(Part(x,2));
WRITE(" ");
       case 1:
W_Mnodes_T7(Part(x,1));
WRITE(" ");
W_Mcode_T12(Part(x,2));
WRITE(" ");
W_Mnodes_T7(Part(x,3));
WRITE(" ");
       case 2:
WRITE("enclosed ");
W_Mnodes_T6(Part(x,1));
WRITE(" ");
       case 3:
W_Mnodes_T11(Part(x,1));
WRITE(" ");
       case 4:
W_INT(Part(x,1));
WRITE(" ");
       case 5:
WRITE("constant ");
W_INT(Part(x,1));
WRITE(" ");
       case 6:
WRITE("constant ");
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
    };
  return 0;
}

int XD_Mnodes_T7(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mcode_T13(Part(x,1));
D_Mnodes_T7(Part(x,2));
            Free(x,3);
            break;
          case 1:
D_Mnodes_T7(Part(x,1));
D_Mcode_T12(Part(x,2));
D_Mnodes_T7(Part(x,3));
            Free(x,4);
            break;
          case 2:
D_Mnodes_T6(Part(x,1));
            Free(x,2);
            break;
          case 3:
D_Mnodes_T11(Part(x,1));
            Free(x,2);
            break;
          case 4:
            Free(x,2);
            break;
          case 5:
            Free(x,2);
            break;
          case 6:
D_TEXT(Part(x,1));
            Free(x,2);
            break;
    };
}

int D_Mnodes_T7(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mnodes_T7(x);
}

/****EXPRESSIONS(nodes)****/

int EQ_Mnodes_T10(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mnodes_T6(Part(x,1),Part(y,1))&&EQ_Mnodes_T10(Part(x,2),Part(y,2));
       case 1:
         return EQ_Mnodes_T10(Part(x,1),Part(y,1));
       case 2:
         return 1;
    };
  return 0;
}

int W_Mnodes_T10(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_Mnodes_T6(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Mnodes_T10(Part(x,2));
WRITE(" ");
       case 1:
WRITE("pass ");
WRITE("two ");
W_Mnodes_T10(Part(x,1));
WRITE(" ");
       case 2:
WRITE("none ");
    };
  return 0;
}

int XD_Mnodes_T10(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mnodes_T6(Part(x,1));
D_Mnodes_T10(Part(x,2));
            Free(x,3);
            break;
          case 1:
D_Mnodes_T10(Part(x,1));
            Free(x,2);
            break;
          case 2:
            Free(x,1);
            break;
    };
}

int D_Mnodes_T10(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mnodes_T10(x);
}

/****VARIABLE(nodes)****/

int EQ_Mnodes_T11(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_Mnodes_T11(Part(x,1),Part(y,1));
       case 1:
         return (Part(x,1) == Part(y,1));
       case 2:
         return (Part(x,1) == Part(y,1));
       case 3:
         return (Part(x,1) == Part(y,1))&&EQ_Mnodes_T7(Part(x,2),Part(y,2));
    };
  return 0;
}

int W_Mnodes_T11(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("concretize ");
W_Mnodes_T11(Part(x,1));
WRITE(" ");
       case 1:
WRITE("unused ");
W_INT(Part(x,1));
WRITE(" ");
       case 2:
W_INT(Part(x,1));
WRITE(" ");
       case 3:
W_INT(Part(x,1));
WRITE(" ");
WRITE("indexed ");
WRITE("by ");
W_Mnodes_T7(Part(x,2));
WRITE(" ");
    };
  return 0;
}

int XD_Mnodes_T11(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mnodes_T11(Part(x,1));
            Free(x,2);
            break;
          case 1:
            Free(x,2);
            break;
          case 2:
            Free(x,2);
            break;
          case 3:
D_Mnodes_T7(Part(x,2));
            Free(x,3);
            break;
    };
}

int D_Mnodes_T11(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mnodes_T11(x);
}

/****NODE(nodes)****/

int EQ_Mnodes_T12(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mnodes_T10(Part(x,2),Part(y,2));
       case 1:
         return (Part(x,1) == Part(y,1))&&EQ_Mnodes_T10(Part(x,2),Part(y,2));
       case 2:
         return EQ_Mnodes_T6(Part(x,1),Part(y,1))&&EQ_Mnodes_T6(Part(x,2),Part(y,2));
       case 3:
         return EQ_Mnodes_T6(Part(x,1),Part(y,1))&&EQ_Mnodes_T6(Part(x,2),Part(y,2));
       case 4:
         return 1;
       case 5:
         return 1;
       case 6:
         return 1;
       case 7:
         return 1;
       case 8:
         return 1;
       case 9:
         return 1;
       case 10:
         return 1;
       case 11:
         return 1;
    };
  return 0;
}

int W_Mnodes_T12(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("call ");
W_INT(Part(x,1));
WRITE(" ");
W_Mnodes_T10(Part(x,2));
WRITE(" ");
       case 1:
WRITE("resolved ");
WRITE("call ");
W_INT(Part(x,1));
WRITE(" ");
W_Mnodes_T10(Part(x,2));
WRITE(" ");
       case 2:
W_Mnodes_T6(Part(x,1));
WRITE(" ");
WRITE("arrow ");
W_Mnodes_T6(Part(x,2));
WRITE(" ");
       case 3:
W_Mnodes_T6(Part(x,1));
WRITE(" ");
WRITE("equal ");
W_Mnodes_T6(Part(x,2));
WRITE(" ");
       case 4:
WRITE("end ");
WRITE("of ");
WRITE("group ");
       case 5:
WRITE("end ");
WRITE("of ");
WRITE("alternative ");
       case 6:
WRITE("end ");
WRITE("of ");
WRITE("pass ");
WRITE("one ");
       case 7:
WRITE("succeed ");
       case 8:
WRITE("fail ");
       case 9:
WRITE("abort ");
       case 10:
WRITE("exit ");
       case 11:
WRITE("empty ");
    };
  return 0;
}

int XD_Mnodes_T12(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mnodes_T10(Part(x,2));
            Free(x,3);
            break;
          case 1:
D_Mnodes_T10(Part(x,2));
            Free(x,3);
            break;
          case 2:
D_Mnodes_T6(Part(x,1));
D_Mnodes_T6(Part(x,2));
            Free(x,3);
            break;
          case 3:
D_Mnodes_T6(Part(x,1));
D_Mnodes_T6(Part(x,2));
            Free(x,3);
            break;
          case 4:
            Free(x,1);
            break;
          case 5:
            Free(x,1);
            break;
          case 6:
            Free(x,1);
            break;
          case 7:
            Free(x,1);
            break;
          case 8:
            Free(x,1);
            break;
          case 9:
            Free(x,1);
            break;
          case 10:
            Free(x,1);
            break;
          case 11:
            Free(x,1);
            break;
    };
}

int D_Mnodes_T12(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mnodes_T12(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(int Mnodes_P_init,());
_PROTOTYPE(int Mnodes_P_error_variable_VARIABLE,(value P0));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));

/*
** CODE
*/

int Mnodes_P_new_NODENR(P0)
value *P0;
{
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = (value)G_nodes_NR_OF_NODES_NR3;
  L1 = (value)G_nodes_NR_OF_NODES_NR3;
  L2 = C_INT(1);
  L3 = C_INT(Int(L1) + Int(L2));
  G_nodes_NR_OF_NODES_NR3 = (long)L3;
  L4 = G_nodes_NODE_NR2896;
  L5 = (value) Addr((value*)&G_nodes_TREE_NR0,Int(L0));
  ATTACH(L4);
if(DecrRefs(*((value*)L5))<0)
XD_Mnodes_T12(*((value*)L5));
  *((value *)L5) = L4;
  L6 = C_INT(0);
  L7 = (value) Addr((value*)&G_nodes_LINENRS_NR1,Int(L0));
  *((value *)L7) = L6;
  L8 = G_nodes_ARCS_NR2897;
  L9 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  ATTACH(L8);
if(DecrRefs(*((value*)L9))<0)
XD_Mnodes_T3(*((value*)L9));
  *((value *)L9) = L8;
  *P0 = L0;
  return 1;
}

int Mnodes_P_store_NODENR_LINENR_NODE(P0,P1,P2)
value P0;
value P1;
value P2;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = P2;
  L3 = (value) Addr((value*)&G_nodes_TREE_NR0,Int(L0));
  ATTACH(L2);
if(DecrRefs(*((value*)L3))<0)
XD_Mnodes_T12(*((value*)L3));
  *((value *)L3) = L2;
  L4 = (value) Addr((value*)&G_nodes_LINENRS_NR1,Int(L0));
  *((value *)L4) = L1;
  return 1;
}

int Mnodes_P_get_NODENR_LINENR_NODE(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_nodes_TREE_NR0,Int(L0));
  L2 = *((value*)L1);
  L3 = (value) Addr((value*)&G_nodes_LINENRS_NR1,Int(L0));
  L4 = *((value*)L3);
  *P2 = L2;
  ATTACH(L2);
  *P1 = L4;
  return 1;
}

int Mnodes_P_append_succeed_NODENR_NODENR(P0,P1)
value P0;
value *P1;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L2 = *((value*)L1);
  ATTACH(L2);
  switch (Alternative(L2)) {
  case 0: goto LAB0;
  default: goto LAB1;
  };
LAB0:
if(DecrRefs(L2)<0)
XD_Mnodes_T3(L2);
  Mnodes_P_new_NODENR(&L3);
  Create(&L4,1,1);
  *(value *)(L4+1) = L3;
if(DecrRefs(*((value*)L1))<0)
XD_Mnodes_T3(*((value*)L1));
  *((value *)L1) = L4;
  *P1 = L3;
  return 1;
LAB1:
if(DecrRefs(L2)<0)
XD_Mnodes_T3(L2);
LAB2:
  L5 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L6 = *((value*)L5);
  ATTACH(L6);
  switch (Alternative(L6)) {
  case 1: goto LAB3;
  default: goto LAB4;
  };
LAB3:
  L7 = (value)(L6[1]);
  Mnodes_P_new_NODENR(&L8);
  Create(&L9,1,1);
  *(value *)(L9+1) = L7;
if(DecrRefs(L6)<0)
XD_Mnodes_T3(L6);
  L10 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L8));
if(DecrRefs(*((value*)L10))<0)
XD_Mnodes_T3(*((value*)L10));
  *((value *)L10) = L9;
  Create(&L11,1,1);
  *(value *)(L11+1) = L8;
if(DecrRefs(*((value*)L5))<0)
XD_Mnodes_T3(*((value*)L5));
  *((value *)L5) = L11;
  *P1 = L8;
  return 1;
LAB4:
if(DecrRefs(L6)<0)
XD_Mnodes_T3(L6);
LAB5:
  L12 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L13 = *((value*)L12);
  ATTACH(L13);
  switch (Alternative(L13)) {
  case 3: goto LAB6;
  default: goto LAB7;
  };
LAB6:
  L14 = (value)(L13[1]);
  L15 = (value)(L13[2]);
  Mnodes_P_new_NODENR(&L16);
  Create(&L17,1,1);
  *(value *)(L17+1) = L14;
  L18 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L16));
if(DecrRefs(*((value*)L18))<0)
XD_Mnodes_T3(*((value*)L18));
  *((value *)L18) = L17;
  Create(&L19,3,2);
  *(value *)(L19+1) = L16;
  *(value *)(L19+2) = L15;
if(DecrRefs(L13)<0)
XD_Mnodes_T3(L13);
if(DecrRefs(*((value*)L12))<0)
XD_Mnodes_T3(*((value*)L12));
  *((value *)L12) = L19;
  *P1 = L16;
  return 1;
LAB7:
if(DecrRefs(L13)<0)
XD_Mnodes_T3(L13);
LAB8:
  L20 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L21 = *((value*)L20);
  ATTACH(L21);
  switch (Alternative(L21)) {
  case 2: goto LAB9;
  default: goto LAB10;
  };
LAB9:
  L22 = (value)(L21[1]);
  Mnodes_P_new_NODENR(&L23);
  Create(&L24,3,2);
  *(value *)(L24+1) = L23;
  *(value *)(L24+2) = L22;
if(DecrRefs(L21)<0)
XD_Mnodes_T3(L21);
if(DecrRefs(*((value*)L20))<0)
XD_Mnodes_T3(*((value*)L20));
  *((value *)L20) = L24;
  *P1 = L23;
  return 1;
LAB10:
if(DecrRefs(L21)<0)
XD_Mnodes_T3(L21);
  Abort(95, module_name);
  Abort(95, module_name);
}

int Mnodes_P_append_fail_NODENR_NODENR(P0,P1)
value P0;
value *P1;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L2 = *((value*)L1);
  ATTACH(L2);
  switch (Alternative(L2)) {
  case 0: goto LAB12;
  default: goto LAB13;
  };
LAB12:
if(DecrRefs(L2)<0)
XD_Mnodes_T3(L2);
  Mnodes_P_new_NODENR(&L3);
  Create(&L4,2,1);
  *(value *)(L4+1) = L3;
if(DecrRefs(*((value*)L1))<0)
XD_Mnodes_T3(*((value*)L1));
  *((value *)L1) = L4;
  *P1 = L3;
  return 1;
LAB13:
if(DecrRefs(L2)<0)
XD_Mnodes_T3(L2);
LAB14:
  L5 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L6 = *((value*)L5);
  ATTACH(L6);
  switch (Alternative(L6)) {
  case 1: goto LAB15;
  default: goto LAB16;
  };
LAB15:
  L7 = (value)(L6[1]);
  Mnodes_P_new_NODENR(&L8);
  Create(&L9,3,2);
  *(value *)(L9+1) = L7;
if(DecrRefs(L6)<0)
XD_Mnodes_T3(L6);
  *(value *)(L9+2) = L8;
if(DecrRefs(*((value*)L5))<0)
XD_Mnodes_T3(*((value*)L5));
  *((value *)L5) = L9;
  *P1 = L8;
  return 1;
LAB16:
if(DecrRefs(L6)<0)
XD_Mnodes_T3(L6);
LAB17:
  L10 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L11 = *((value*)L10);
  ATTACH(L11);
  switch (Alternative(L11)) {
  case 3: goto LAB18;
  default: goto LAB19;
  };
LAB18:
  L12 = (value)(L11[1]);
  L13 = (value)(L11[2]);
  Mnodes_P_new_NODENR(&L14);
  Create(&L15,2,1);
  *(value *)(L15+1) = L13;
  L16 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L14));
if(DecrRefs(*((value*)L16))<0)
XD_Mnodes_T3(*((value*)L16));
  *((value *)L16) = L15;
  Create(&L17,3,2);
  *(value *)(L17+1) = L12;
if(DecrRefs(L11)<0)
XD_Mnodes_T3(L11);
  *(value *)(L17+2) = L14;
if(DecrRefs(*((value*)L10))<0)
XD_Mnodes_T3(*((value*)L10));
  *((value *)L10) = L17;
  *P1 = L14;
  return 1;
LAB19:
if(DecrRefs(L11)<0)
XD_Mnodes_T3(L11);
LAB20:
  L18 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L19 = *((value*)L18);
  ATTACH(L19);
  switch (Alternative(L19)) {
  case 2: goto LAB21;
  default: goto LAB22;
  };
LAB21:
  L20 = (value)(L19[1]);
  Mnodes_P_new_NODENR(&L21);
  Create(&L22,2,1);
  *(value *)(L22+1) = L20;
if(DecrRefs(L19)<0)
XD_Mnodes_T3(L19);
  L23 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L21));
if(DecrRefs(*((value*)L23))<0)
XD_Mnodes_T3(*((value*)L23));
  *((value *)L23) = L22;
  Create(&L24,2,1);
  *(value *)(L24+1) = L21;
if(DecrRefs(*((value*)L18))<0)
XD_Mnodes_T3(*((value*)L18));
  *((value *)L18) = L24;
  *P1 = L21;
  return 1;
LAB22:
if(DecrRefs(L19)<0)
XD_Mnodes_T3(L19);
  Abort(112, module_name);
  Abort(112, module_name);
}

int Mnodes_P_succeed_NODENR_NODENR(P0,P1)
value P0;
value *P1;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 1: goto LAB24;
  default: goto LAB26;
  };
LAB24:
  L3 = (value)(L2[1]);
  *P1 = L3;
  return 1;
LAB26:
  L4 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L5 = *((value*)L4);
  switch (Alternative(L5)) {
  case 3: goto LAB27;
  default: goto LAB29;
  };
LAB27:
  L6 = (value)(L5[1]);
  L7 = (value)(L5[2]);
  *P1 = L6;
  return 1;
LAB29:
  return 0;
}

int Mnodes_P_fail_NODENR_NODENR(P0,P1)
value P0;
value *P1;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L2 = *((value*)L1);
  switch (Alternative(L2)) {
  case 2: goto LAB30;
  default: goto LAB32;
  };
LAB30:
  L3 = (value)(L2[1]);
  *P1 = L3;
  return 1;
LAB32:
  L4 = (value) Addr((value*)&G_nodes_ARCS_NR2,Int(L0));
  L5 = *((value*)L4);
  switch (Alternative(L5)) {
  case 3: goto LAB33;
  default: goto LAB35;
  };
LAB33:
  L6 = (value)(L5[1]);
  L7 = (value)(L5[2]);
  *P1 = L7;
  return 1;
LAB35:
  return 0;
}

int Mnodes_P_pass_two_NODENR_NODENR(P0,P1)
value P0;
value *P1;
{
  value L0;
  L0 = P0;
  return 0;
}

int Mnodes_P_error_SUBEXPRESSION(P0)
value P0;
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB83:
  switch (Alternative(L0)) {
  case 0: goto LAB36;
  case 1: goto LAB39;
  case 2: goto LAB42;
  case 4: goto LAB45;
  case 5: goto LAB48;
  case 6: goto LAB51;
  case 3: goto LAB54;
  default: goto LAB56;
  };
LAB36:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Mcode_P_error_MONADIC_OPERATOR(L1);
  L0 = L2;
  goto LAB83;
LAB39:
  L3 = (value)(L0[1]);
  L4 = (value)(L0[2]);
  L5 = (value)(L0[3]);
  Mnodes_P_error_SUBEXPRESSION(L3);
  Mcode_P_error_OPERATOR(L4);
  L0 = L5;
  goto LAB83;
LAB42:
  L6 = (value)(L0[1]);
  L7 = G_nodes_TEXT_NR2900;
  Merrors_P_error_text_TEXT(L7);
  Mnodes_P_error_EXPRESSION(L6);
  L8 = G_nodes_TEXT_NR2901;
  Merrors_P_error_text_TEXT(L8);
  return 1;
LAB45:
  L9 = (value)(L0[1]);
  Mterminals_P_error_terminal_TERMINALNR(L9);
  return 1;
LAB48:
  L10 = (value)(L0[1]);
  Merrors_P_error_int_INT(L10);
  return 1;
LAB51:
  L11 = (value)(L0[1]);
  Merrors_P_error_text_TEXT(L11);
  return 1;
LAB54:
  L12 = (value)(L0[1]);
  Mnodes_P_error_variable_VARIABLE(L12);
  return 1;
LAB56:
  Abort(145, module_name);
}

int Mnodes_P_error_EXPRESSION(P0)
value P0;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB81:
  switch (Alternative(L0)) {
  case 1: goto LAB57;
  case 2: goto LAB63;
  case 0: goto LAB66;
  default: goto LAB68;
  };
LAB57:
  L1 = (value)(L0[1]);
  L2 = (value)(L0[2]);
  Mnodes_P_error_SUBEXPRESSION(L1);
  switch (Alternative(L2)) {
  case 2: goto LAB60;
  default: goto LAB62;
  };
LAB60:
  return 1;
LAB62:
  L3 = G_nodes_TEXT_NR2902;
  Merrors_P_error_text_TEXT(L3);
  L0 = L2;
  goto LAB81;
LAB63:
  return 1;
LAB66:
  L4 = (value)(L0[1]);
  L5 = (value)(L0[2]);
  Mnodes_P_error_EXPRESSION(L4);
  L6 = G_nodes_TEXT_NR2903;
  Merrors_P_error_text_TEXT(L6);
  L0 = L5;
  goto LAB81;
LAB68:
  Abort(178, module_name);
}

int Mnodes_P_init()
{
  value L0;
  L0 = C_INT(0);
  G_nodes_NR_OF_NODES_NR3 = (long)L0;
  return 1;
}

int Mnodes_P_error_variable_VARIABLE(P0)
value P0;
{
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB82:
  switch (Alternative(L0)) {
  case 1: goto LAB69;
  case 0: goto LAB72;
  case 2: goto LAB75;
  case 3: goto LAB78;
  default: goto LAB80;
  };
LAB69:
  L1 = (value)(L0[1]);
  Mtypes_P_error_TYPENR(L1);
  L2 = G_nodes_TEXT_NR2904;
  Merrors_P_error_text_TEXT(L2);
  return 1;
LAB72:
  L3 = (value)(L0[1]);
  L4 = G_nodes_TEXT_NR2905;
  Merrors_P_error_text_TEXT(L4);
  L0 = L3;
  goto LAB82;
LAB75:
  L5 = (value)(L0[1]);
  Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE(L5,&L6,&L7,&L8,&L9);
if(DecrRefs(L9)<0)
XD_Mvariables_T9(L9);
  Mtypes_P_error_TYPENR(L7);
  Mvariables_P_error_INSTANCE(L8);
if(DecrRefs(L8)<0)
XD_Mvariables_T8(L8);
  return 1;
LAB78:
  L10 = (value)(L0[1]);
  L11 = (value)(L0[2]);
  Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE(L10,&L12,&L13,&L14,&L15);
if(DecrRefs(L15)<0)
XD_Mvariables_T9(L15);
  Mtypes_P_error_TYPENR(L13);
  Mvariables_P_error_INSTANCE(L14);
if(DecrRefs(L14)<0)
XD_Mvariables_T8(L14);
  L16 = G_nodes_TEXT_NR2906;
  Merrors_P_error_text_TEXT(L16);
  Mnodes_P_error_SUBEXPRESSION(L11);
  L17 = G_nodes_TEXT_NR2907;
  Merrors_P_error_text_TEXT(L17);
  return 1;
LAB80:
  Abort(165, module_name);
}

