REM ------------------------------------------------------------
REM   PURPOSE: TEST THE PARAMETER RANGE CHECKS
REM    AUTHOR: HOWARD WULF, AF5NE
REM GENERATED: 02/21/2015 14:08:33
REM  FILENAME: F_SIN_X_N.BAS
REM    SYNTAX: N  = SIN( X )
REM  UNIQUEID: F_SIN_X_N
REM  FUNCTION: SIN
REM 
REM	VARIABLE	DESCRIPTION
REM	I	CURRENT  TESTCASE NUMBER
REM	E	EXPECTED ERROR FLAG
REM	F	ACTUAL   ERROR FLAG
REM	R	EXPECTED FUNCTION RESULT
REM	N	ACTUAL   FUNCTION RESULT
REM	X	ACTUAL   FUNCTION PARAMETER
REM 
RESTORE 2000
REM GET TESTCASE #
READ  I
WHILE I > 0
REM GET TESTCASE DATA
READ  E, R, X
REM DISPLAY TESTCASE DATA
PRINT "TESTCASE #";I,"E=";E,"R=";R, "X=";X
REM EXECUTE TESTCASE
N =  0 
S$ = ""
ON ERROR GOTO 9000
F = 0
999 N  = SIN( X )
ERROR 0
REM DISPLAY TESTCASE RESULTS
PRINT ,"F=";F,"N=";N
REM VERIFY EXPECTED ERROR
IF E <> F THEN
  PRINT "*** TEST FAILED, EXCEPTION MISMATCH ***"
  STOP
END IF
REM VERIFY EXPECTED RESULT
IF R > 0 THEN
  LET RMIN = 0.99 * R
  IF R > MAXNUM / 1.012 THEN
    LET RMAX = MAXNUM
  ELSE
    LET RMAX = 1.01 * R
  END IF
END IF
IF R < 0 THEN
  IF R < - MAXNUM / 1.012 THEN
    LET RMIN = -MAXNUM
  ELSE
    LET RMIN = 1.01 * R
  END IF
  LET RMAX = 0.99 * R
END IF
IF R = 0 THEN
  LET RMIN = -.01
  LET RMAX = +.01
END IF
IF N < RMIN THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
IF N > RMAX THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
PRINT "*** TEST PASSED ***"
REM GET NEXT TESTCASE #
READ  I
WEND
PRINT "*** ALL TESTS PASSED ***"
GOTO 9999
1999 REM TESTCASE, EXPECTED ERROR, EXPECTED RESULT, PARAMETERS...
DATA  1 ,  0 ,  0 ,  0 
DATA  2 ,  0 ,  .841471 ,  1 
DATA  3 ,  0 , -.841471 , -1 
DATA  4 ,  0 ,  .389418 ,  .4 
DATA  5 ,  0 , -.389418 , -.4 
DATA  6 ,  0 ,  .564642 ,  .6 
DATA  7 ,  0 , -.564642 , -.6 
DATA  8 ,  0 ,  .451999 ,  254 
DATA  9 ,  0 , -.506392 ,  255 
DATA  10 ,  0 , -.999208 ,  256 
DATA  11 ,  0 , -.259756 ,  32000 
DATA  12 ,  0 , -.225279 , -.227229 
DATA  13 ,  0 , -.236884 , -.239157 
DATA  14 ,  0 , -.211966 , -.213586 
DATA  15 ,  0 ,  .271234 ,  .274675 
DATA  16 ,  0 ,  .168952 ,  .169766 
DATA  17 ,  0 ,  .313395 ,  .318766 
DATA  18 ,  0 ,  2.06643E-2 ,  2.06658E-2 
DATA  19 ,  0 ,  .187147 ,  .188257 
DATA  20 ,  0 , -.273988 , -.277537 
DATA  21 ,  0 , -.462935 , -.481303 
DATA  22 ,  0 ,  .421918 ,  .43556 
DATA  23 ,  0 , -.209409 , -.210971 
DATA  24 ,  0 , -.439656 , -.455216 
DATA  25 ,  0 ,  .814146 , -110.907 
DATA  26 ,  0 , -.925423 ,  105.632 
DATA  27 ,  0 , -.946968 , -114.341 
DATA  28 ,  0 ,  .247155 ,  109.706 
DATA  29 ,  0 ,  .687284 ,  109.198 
DATA  30 ,  0 , -.869554 ,  85.8773 
DATA  31 ,  0 , -.972436 , -58.3548 
DATA  32 ,  0 , -.978973 ,  29.6397 
DATA  33 ,  0 , -.999689 , -108.36 
DATA  34 ,  0 , -.567931 , -46.5199 
DATA  35 ,  0 , -.544955 ,  112.521 
DATA  36 ,  0 ,  .990494 ,  45.4151 
DATA  37 ,  0 ,  .56302 ,  101.129 
DATA  38 ,  0 ,  .79931 ,  65.0473 
DATA  39 ,  0 , -.957241 ,  48.4012 
DATA  40 ,  0 ,  .22614 ,  122.294 
DATA  41 ,  0 ,  .425277 , -56.1094 
DATA  42 ,  0 , -.990809 , -121.087 
DATA  43 ,  0 ,  .838697 , -123.517 
DATA  44 ,  0 ,  .238409 , -97.6301 
DATA  45 ,  0 , -.920065 , -64.0001 
DATA  46 ,  0 , -.527843 , -25.6888 
DATA  47 ,  0 ,  .787883 ,  14.8006 
DATA  48 ,  0 ,  .985011 , -61.0877 
DATA  49 ,  0 ,  .616787 , -66.6381 
DATA  50 ,  0 ,  .647276 , -5476.5 
DATA  51 ,  0 ,  .986777 , -21210.3 
DATA  52 ,  0 ,  .807057 , -28757.2 
DATA  53 ,  0 ,  .721807 , -28732.2 
DATA  54 ,  0 ,  .536739 ,  12730.3 
DATA  55 ,  0 , -.756874 , -1830.69 
DATA  56 ,  0 ,  .920449 ,  5486.39 
DATA  57 ,  0 ,  6.11564E-2 ,  22405.9 
DATA  58 ,  0 , -.199499 ,  30809.8 
DATA  59 ,  0 , -.320964 , -28930.6 
DATA  60 ,  0 , -.998793 , -6014.53 
DATA  61 ,  0 , -.683043 ,  17414.6 
DATA  62 ,  0 , -.985149 , -10538.3 
DATA  63 ,  0 ,  7.01347E-2 , -17536.3 
DATA  64 ,  0 ,  .453162 , -8856.62 
DATA  65 ,  0 , -.456821 , -5140.12 
DATA  66 ,  0 ,  8.73886E-2 , -8595.31 
DATA  67 ,  0 , -.585331 , -3382.87 
DATA  68 ,  0 , -.608759 , -5002.07 
DATA  69 ,  0 , -.973476 , -5800.72 
DATA  70 ,  0 , -.996819 ,  29686.4 
DATA  71 ,  0 ,  .923539 ,  2571. 
DATA  72 ,  0 ,  .974052 ,  31091. 
DATA  73 ,  0 , -.107246 ,  14819. 
DATA  74 ,  0 ,  .842729 ,  3790.9 
DATA  75 ,  0 ,  .571013 , -4.2981E+9 
DATA  76 ,  0 , -.420125 , -7.05453E+8 
DATA  77 ,  0 ,  .408592 , -3.10179E+9 
DATA  78 ,  0 ,  .974347 , -4.86159E+9 
DATA  79 ,  0 ,  .744018 , -8.62908E+8 
DATA  80 ,  0 , -.381683 , -3.4101E+9 
DATA  81 ,  0 , -.78677 ,  3.3889E+9 
DATA  82 ,  0 ,  .723606 ,  2.49826E+9 
DATA  83 ,  0 , -.912251 ,  2.3491E+9 
DATA  84 ,  0 ,  .62558 ,  1.94745E+8 
DATA  85 ,  0 ,  .158389 ,  2.02475E+9 
DATA  86 ,  0 , -.762398 , -2.26748E+9 
DATA  87 ,  0 , -5.60771E-2 , -2.10587E+9 
DATA  88 ,  0 , -.942582 ,  4.23585E+9 
DATA  89 ,  0 ,  .164144 , -2.66524E+9 
DATA  90 ,  0 ,  .733648 ,  4.01052E+9 
DATA  91 ,  0 ,  .376706 , -4.87912E+9 
DATA  92 ,  0 , -.99923 ,  1.77556E+9 
DATA  93 ,  0 , -.57627 ,  2.87705E+8 
DATA  94 ,  0 ,  .336893 ,  1.99977E+8 
DATA  95 ,  0 , -.567372 , -3.39941E+9 
DATA  96 ,  0 ,  .989581 , -3.49119E+9 
DATA  97 ,  0 , -.998595 , -2.86324E+9 
DATA  98 ,  0 , -.801884 ,  4.20418E+9 
DATA  99 ,  0 ,  .758508 , -3.1518E+9 
DATA  100 ,  0 ,  .696967 ,  4.60615E+9 
DATA 0
9000 REM ERROR HANDLER
IF ERL = 999 THEN
  F = ABS(SGN(ERR))
  RESUME NEXT
END IF
PRINT "*** UNEXPECTED ERROR ON LINE ";ERL;" ***"
9999 END
