REM ------------------------------------------------------------
REM   PURPOSE: TEST THE PARAMETER RANGE CHECKS
REM    AUTHOR: HOWARD WULF, AF5NE
REM GENERATED: 02/21/2015 14:08:20
REM  FILENAME: F_DEG_X_N.BAS
REM    SYNTAX: N  = DEG( X )
REM  UNIQUEID: F_DEG_X_N
REM  FUNCTION: DEG
REM 
REM	VARIABLE	DESCRIPTION
REM	I	CURRENT  TESTCASE NUMBER
REM	E	EXPECTED ERROR FLAG
REM	F	ACTUAL   ERROR FLAG
REM	R	EXPECTED FUNCTION RESULT
REM	N	ACTUAL   FUNCTION RESULT
REM	X	ACTUAL   FUNCTION PARAMETER
REM 
RESTORE 2000
REM GET TESTCASE #
READ  I
WHILE I > 0
REM GET TESTCASE DATA
READ  E, R, X
REM DISPLAY TESTCASE DATA
PRINT "TESTCASE #";I,"E=";E,"R=";R, "X=";X
REM EXECUTE TESTCASE
N =  0 
S$ = ""
ON ERROR GOTO 9000
F = 0
999 N  = DEG( X )
ERROR 0
REM DISPLAY TESTCASE RESULTS
PRINT ,"F=";F,"N=";N
REM VERIFY EXPECTED ERROR
IF E <> F THEN
  PRINT "*** TEST FAILED, EXCEPTION MISMATCH ***"
  STOP
END IF
REM VERIFY EXPECTED RESULT
IF R > 0 THEN
  LET RMIN = 0.99 * R
  IF R > MAXNUM / 1.012 THEN
    LET RMAX = MAXNUM
  ELSE
    LET RMAX = 1.01 * R
  END IF
END IF
IF R < 0 THEN
  IF R < - MAXNUM / 1.012 THEN
    LET RMIN = -MAXNUM
  ELSE
    LET RMIN = 1.01 * R
  END IF
  LET RMAX = 0.99 * R
END IF
IF R = 0 THEN
  LET RMIN = -.01
  LET RMAX = +.01
END IF
IF N < RMIN THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
IF N > RMAX THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
PRINT "*** TEST PASSED ***"
REM GET NEXT TESTCASE #
READ  I
WEND
PRINT "*** ALL TESTS PASSED ***"
GOTO 9999
1999 REM TESTCASE, EXPECTED ERROR, EXPECTED RESULT, PARAMETERS...
DATA  1 ,  0 ,  0 ,  0 
DATA  2 ,  0 ,  57.2958 ,  1 
DATA  3 ,  0 , -57.2958 , -1 
DATA  4 ,  0 ,  22.9183 ,  .4 
DATA  5 ,  0 , -22.9183 , -.4 
DATA  6 ,  0 ,  34.3775 ,  .6 
DATA  7 ,  0 , -34.3775 , -.6 
DATA  8 ,  0 ,  14553.1 ,  254 
DATA  9 ,  0 ,  14610.4 ,  255 
DATA  10 ,  0 ,  14667.7 ,  256 
DATA  11 ,  0 ,  1.83346E+6 ,  32000 
DATA  12 ,  0 , -13.0193 , -.227229 
DATA  13 ,  0 , -13.7027 , -.239157 
DATA  14 ,  0 , -12.2376 , -.213586 
DATA  15 ,  0 ,  15.7377 ,  .274675 
DATA  16 ,  0 ,  9.72688 ,  .169766 
DATA  17 ,  0 ,  18.2639 ,  .318766 
DATA  18 ,  0 ,  1.18406 ,  2.06658E-2 
DATA  19 ,  0 ,  10.7863 ,  .188257 
DATA  20 ,  0 , -15.9017 , -.277537 
DATA  21 ,  0 , -27.5766 , -.481303 
DATA  22 ,  0 ,  24.9557 ,  .43556 
DATA  23 ,  0 , -12.0877 , -.210971 
DATA  24 ,  0 , -26.082 , -.455216 
DATA  25 ,  0 , -6354.5 , -110.907 
DATA  26 ,  0 ,  6052.27 ,  105.632 
DATA  27 ,  0 , -6551.26 , -114.341 
DATA  28 ,  0 ,  6285.69 ,  109.706 
DATA  29 ,  0 ,  6256.58 ,  109.198 
DATA  30 ,  0 ,  4920.41 ,  85.8773 
DATA  31 ,  0 , -3343.48 , -58.3548 
DATA  32 ,  0 ,  1698.23 ,  29.6397 
DATA  33 ,  0 , -6208.57 , -108.36 
DATA  34 ,  0 , -2665.39 , -46.5199 
DATA  35 ,  0 ,  6446.98 ,  112.521 
DATA  36 ,  0 ,  2602.09 ,  45.4151 
DATA  37 ,  0 ,  5794.26 ,  101.129 
DATA  38 ,  0 ,  3726.94 ,  65.0473 
DATA  39 ,  0 ,  2773.18 ,  48.4012 
DATA  40 ,  0 ,  7006.93 ,  122.294 
DATA  41 ,  0 , -3214.83 , -56.1094 
DATA  42 ,  0 , -6937.77 , -121.087 
DATA  43 ,  0 , -7077. , -123.517 
DATA  44 ,  0 , -5593.79 , -97.6301 
DATA  45 ,  0 , -3666.94 , -64.0001 
DATA  46 ,  0 , -1471.86 , -25.6888 
DATA  47 ,  0 ,  848.012 ,  14.8006 
DATA  48 ,  0 , -3500.07 , -61.0877 
DATA  49 ,  0 , -3818.08 , -66.6381 
DATA  50 ,  0 , -313780. , -5476.5 
DATA  51 ,  0 , -1.21526E+6 , -21210.3 
DATA  52 ,  0 , -1.64767E+6 , -28757.2 
DATA  53 ,  0 , -1.64623E+6 , -28732.2 
DATA  54 ,  0 ,  729392. ,  12730.3 
DATA  55 ,  0 , -104891. , -1830.69 
DATA  56 ,  0 ,  314347. ,  5486.39 
DATA  57 ,  0 ,  1.28376E+6 ,  22405.9 
DATA  58 ,  0 ,  1.76527E+6 ,  30809.8 
DATA  59 ,  0 , -1.6576E+6 , -28930.6 
DATA  60 ,  0 , -344607. , -6014.53 
DATA  61 ,  0 ,  997783. ,  17414.6 
DATA  62 ,  0 , -603800. , -10538.3 
DATA  63 ,  0 , -1.00476E+6 , -17536.3 
DATA  64 ,  0 , -507447. , -8856.62 
DATA  65 ,  0 , -294507. , -5140.12 
DATA  66 ,  0 , -492475. , -8595.31 
DATA  67 ,  0 , -193824. , -3382.87 
DATA  68 ,  0 , -286597. , -5002.07 
DATA  69 ,  0 , -332357. , -5800.72 
DATA  70 ,  0 ,  1.70091E+6 ,  29686.4 
DATA  71 ,  0 ,  147307. ,  2571. 
DATA  72 ,  0 ,  1.78138E+6 ,  31091. 
DATA  73 ,  0 ,  849066. ,  14819. 
DATA  74 ,  0 ,  217203. ,  3790.9 
DATA  75 ,  0 , -2.46263E+11 , -4.2981E+9 
DATA  76 ,  0 , -4.04195E+10 , -7.05453E+8 
DATA  77 ,  0 , -1.77719E+11 , -3.10179E+9 
DATA  78 ,  0 , -2.78549E+11 , -4.86159E+9 
DATA  79 ,  0 , -4.9441E+10 , -8.62908E+8 
DATA  80 ,  0 , -1.95384E+11 , -3.4101E+9 
DATA  81 ,  0 ,  1.9417E+11 ,  3.3889E+9 
DATA  82 ,  0 ,  1.4314E+11 ,  2.49826E+9 
DATA  83 ,  0 ,  1.34594E+11 ,  2.3491E+9 
DATA  84 ,  0 ,  1.11581E+10 ,  1.94745E+8 
DATA  85 ,  0 ,  1.1601E+11 ,  2.02475E+9 
DATA  86 ,  0 , -1.29917E+11 , -2.26748E+9 
DATA  87 ,  0 , -1.20657E+11 , -2.10587E+9 
DATA  88 ,  0 ,  2.42696E+11 ,  4.23585E+9 
DATA  89 ,  0 , -1.52707E+11 , -2.66524E+9 
DATA  90 ,  0 ,  2.29786E+11 ,  4.01052E+9 
DATA  91 ,  0 , -2.79553E+11 , -4.87912E+9 
DATA  92 ,  0 ,  1.01732E+11 ,  1.77556E+9 
DATA  93 ,  0 ,  1.64843E+10 ,  2.87705E+8 
DATA  94 ,  0 ,  1.14578E+10 ,  1.99977E+8 
DATA  95 ,  0 , -1.94772E+11 , -3.39941E+9 
DATA  96 ,  0 , -2.0003E+11 , -3.49119E+9 
DATA  97 ,  0 , -1.64052E+11 , -2.86324E+9 
DATA  98 ,  0 ,  2.40882E+11 ,  4.20418E+9 
DATA  99 ,  0 , -1.80585E+11 , -3.1518E+9 
DATA  100 ,  0 ,  2.63913E+11 ,  4.60615E+9 
DATA 0
9000 REM ERROR HANDLER
IF ERL = 999 THEN
  F = ABS(SGN(ERR))
  RESUME NEXT
END IF
PRINT "*** UNEXPECTED ERROR ON LINE ";ERL;" ***"
9999 END
