10 PRINT "PROGRAM FILE 136: GAP TEST FOR RND FUNCTION."
20 PRINT "    ANSI STANDARD 8.4"
30 PRINT
40 PRINT "SECTION 136.1: GAP TEST FOR RND FUNCTION."
50 PRINT
60 PRINT "THIS PROGRAM TESTS THAT THE GAPS BETWEEN NUMBERS WITHIN"
70 PRINT "A SPECIFIED INTERVAL ARE DISTRIBUTED AS EXPECTED FOR"
80 PRINT "UNIFORMLY DISTRIBUTED RANDOM NUMBERS. CHI-SQUARE IS"
90 PRINT "COMPUTED AND DISPLAYED AS THE RESULT."
100 PRINT
110 PRINT "***** THIS TEST IS INFORMATIVE ONLY. *****"
120 PRINT
130 PRINT "                    BEGIN TEST"
140 PRINT
150 DIM C(121)
160 REM SET BOUNDS FOR GAP TEST
170 REM CONSOLIDATE ALL GAPS >= 10
180 LET T=10
190 REM SET LOW END OF HIT INTERVAL
200 LET A1=.03
210 REM SET HIGH END OF HIT INTERVAL
220 LET A2=.13
230 REM SET SIZE OF HIT INTERVAL
240 LET A3=A2-A1
250 REM PROB. THAT GAP >= T
260 LET P1=(1-A3)^T
270 REM PROB. THAT GAP = T-1
280 LET P2=A3*((1-A3)^(T-1))
290 IF P1<P2 THEN 330
300 LET P1=P2
310 REM P1 IS PROBABILITY OF LEAST PROBABLE CATEGORY
320 REM WANT EXPECTED NUMBER >= 10
330 LET N=INT(10/P1)+1
340 PRINT
350 PRINT "WILL RUN ";N;" TRIALS, SO THAT EACH POSSIBILITY HAS"
360 PRINT "EXPECTED VALUE >= 10."
370 FOR I=0 TO T
380 LET C(I)=0
390 NEXT I
400 PRINT
410 PRINT
420 PRINT "GAP SIZE","ACTUAL COUNT","EXPECTED COUNT"
430 PRINT
440 FOR N1=1 TO N
450 LET R=0
460 LET X=RND
470 IF X<A1 THEN 500
480 IF X<A2 THEN 530
490 REM MISSED - KEEP TRYING
500 LET R=R+1
510 GOTO 460
520 REM HIT DESIGNATED INTERVAL
530 IF R<=T THEN 550
540 LET R=T
550 LET C(R)=C(R)+1
560 NEXT N1
565 REM      MR. HAM HAD TO ADD LINE 566 TO INITIALIZE S TO AVOID CRASH
566 LET S=0
570 FOR I=0 TO T
580 LET P9=(1-A3)^I
590 IF I=T THEN 630
600 LET P9=P9*A3
610 PRINT I,C(I),P9*N
620 GOTO 650
630 REM P9=PROB OF GAP OF SIZE I
640 PRINT ">=";I,C(I),P9*N
650 LET S=S+(C(I)*C(I)/P9)
660 NEXT I
670 LET V=(S/N)-N
680 PRINT
690 PRINT "FOR 10 D.F., SHOULD HAVE 3.9403 <= CHI-SQ <= 18.307"
700 PRINT "(5% TAIL AT EACH END.)"
710 PRINT
720 PRINT "ACTUAL CHI-SQ = ";V
730 PRINT
740 IF V<3.9403 THEN 780
750 IF V>18.307 THEN 780
760 PRINT "*** INFORMATIVE TEST PASSED ***"
770 GOTO 790
780 PRINT "*** INFORMATIVE TEST FAILED ***"
790 PRINT
800 PRINT "                 END TEST"
810 PRINT
820 PRINT "END PROGRAM 136"
830 END
