/*	$KAME$	*/

/*
 * Copyright (C) 1998, 1999, 2000 and 2001 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 *	Copyright(c) 1999
 *	Keisuke UEHARA(kei@wide.ad.jp)
 *	All rights reserved.
 */
/*
 *	Copyright(c) 1998,1999
 *	Masahiro ISHIYAMA(masahiro@isl.rdc.toshiba.co.jp)
 *	All rights reserved.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/proc.h>

#include <sys/socket.h>
#include <net/if.h>
#include <net/if_dl.h>

#ifdef HAVE_GETIFADDRS
#include <ifaddrs.h>
#else
#if defined(__FreeBSD__)
#include <osreldate.h>
#if (__FreeBSD_version == 199702) || (__FreeBSD_version >= 300000)
#include <net/if_var.h>
#endif
#endif
#include <sys/sysctl.h>
#include <net/route.h>
#endif

/* Determine if "bits" is set in "flag" */
#define ALLSET(flag, bits) (((flag) & (bits)) == (bits))

int
getmac(ifname, result)
	char *ifname;
	char *result;
{
#ifdef HAVE_GETIFADDRS
	struct ifaddrs *ifa, *ifap;
	struct sockaddr_dl *sdl;

	if (getifaddrs(&ifap) < 0)
		return -1;

	for (ifa = ifap; ifa; ifa = ifa->ifa_next) {
		if (strcmp(ifname, ifa->ifa_name) != 0)
			continue;
		if (!ALLSET(ifa->ifa_flags, IFF_UP | IFF_BROADCAST))
			continue;
		if (ifa->ifa_addr->sa_family != AF_LINK)
			continue;

		sdl = (struct sockaddr_dl *)ifa->ifa_addr;
		bcopy(LLADDR(sdl), result, 6);
		freeifaddrs(ifap);
		return 0;
	}

	freeifaddrs(ifap);
	return -1;
#else
	int flags;
	struct  if_msghdr *ifm, *nextifm;
	struct  ifa_msghdr *ifam;
	struct  sockaddr_dl *sdl;
	char    *buf, *lim, *next;
	size_t needed;
	int mib[6];

	mib[0] = CTL_NET;
	mib[1] = PF_ROUTE;
	mib[2] = 0;
	mib[3] = AF_INET;
	mib[4] = NET_RT_IFLIST;
	mib[5] = 0;

	if (sysctl(mib, 6, NULL, &needed, NULL, 0) < 0)
		return(-1);
	if ((buf = malloc(needed)) == NULL)
		return(-1);
	if (sysctl(mib, 6, buf, &needed, NULL, 0) < 0)
		return(-1);
	lim = buf + needed;

	next = buf;
	while (next < lim) {
		ifm = (struct if_msghdr *)next;
			
		if (ifm->ifm_type == RTM_IFINFO) {
			sdl = (struct sockaddr_dl *)(ifm + 1);
			flags = ifm->ifm_flags;
		} else
			return (-1);

		next += ifm->ifm_msglen;
		ifam = NULL;
		while (next < lim) {
			nextifm = (struct if_msghdr *)next;

			if (nextifm->ifm_type != RTM_NEWADDR)
				break;

			if (ifam == NULL)
				ifam = (struct ifa_msghdr *)nextifm;

			next += nextifm->ifm_msglen;
		}

		/* Only look at configured, broadcast interfaces */
		if (!ALLSET(flags, IFF_UP | IFF_BROADCAST))
			continue;

		/* Only look at the specified interface */
		if (strlen(ifname) != sdl->sdl_nlen)
			continue; /* not same len */
		if (strncmp(ifname, sdl->sdl_data, sdl->sdl_nlen) != 0)
			continue; /* not same name */

		/* found */
		bcopy(LLADDR(sdl), result, 6);
		free(buf);
		return(0);
	}
	/* not found */
	free(buf);
	errno = 0;
	return(-1);
#endif
}
