/*
 * Copyright (c) 2001 Tommy Bohlin <tommy@gatespace.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* obexformat.c
 */

#include <obexformat.h>

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

/**********************************************************************
 * Internal functions
 **********************************************************************/

static void putShort(int n)
{
  putchar(n>>8);
  putchar(n);
}

static void putLong(int n)
{
  putchar(n>>24);
  putchar(n>>16);
  putchar(n>>8);
  putchar(n);
}

static void putUnicode(int hi, const void* buf0, int len)
{
  const u_char* buf=(u_char*)buf0;
  int i;

  putchar(hi|TYPE_UNICODE);
  putShort(2*len+5);
  for(i=0;i<len;i++) putShort(buf[i]);
  putShort(0);
}

static void putBytes(int hi, const void* buf0, int len)
{
  const u_char* buf=(u_char*)buf0;
  int i;

  putchar(hi|TYPE_BYTES);
  putShort(len+3);
  for(i=0;i<len;i++) putchar(buf[i]);
}

#if 0
static void putInt1(int hi, int len)
{
  putchar(hi|TYPE_INT1);
  putchar(len);
}
#endif

static void putInt4(int hi, int len)
{
  putchar(hi|TYPE_INT4);
  putLong(len);
}

/**********************************************************************
 * External functions
 **********************************************************************/

void putName(const void* name, int len)
{
  putUnicode(HI_NAME,name,len);
}

void putLength(int len)
{
  putInt4(HI_LENGTH,len);
}

void putDate(int date)
{
  putInt4(HI_DATE,date);
}

void putDescription(const void* desc, int len)
{
  putUnicode(HI_DESCRIPTION,desc,len);
}

void putClass(int class)
{
  putInt4(HI_CLASS,class);
}

void putBody(const void* body, int len)
{
  putBytes(HI_BODY,body,len);
}

void putEndOfBody(const void* body, int len)
{
  putBytes(HI_END_OF_BODY,body,len);
}
