// bbweather.h for bbweather - an tool for display the date in X11.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//


#ifndef __MAIN_H
#define __MAIN_H

#include "Image.h"
#include "Basewindow.h"
#include "resource.h"

#define LEFT_BUTTON 1
#define MIDDLE_BUTTON 2
#define RIGHT_BUTTON 3

class Resource;
class BaseResource;
class Basewindow;

struct PIXMAP {
	Pixmap 	frame;
	Pixmap	label;
};

struct GEOM {
	int height;
	int width;
	int x;
	int y;
};

struct OPTIONS
{
	bool 	optwithdrawn;
	bool 	optmetric;
	bool 	optcycle;
	bool 	optextra;
	bool 	optshape;
	int 	opttime;
	int 	optupdt;
	char 	*optstation;
	char 	*wthrdir;
	char 	*cnfg;
	char 	*geom;
	int	 zone;
};

class ToolWindow :public Basewindow
{
	public:
		ToolWindow(struct OPTIONS *);
		~ToolWindow(void); 

		XGCValues gcv;
		GC frameGC;

		Window framewin;
		Window labelwin;
		Resource *resource;
		char *position;
		int ticks, updt;
		bool raised, metric, cycle, extra, withdrawn, shape;

		void MakeWindow(bool);
		void CheckWeather(bool);
		void EventLoop(void);
		void Reconfigure(void);
		void Redraw(int);
		void prepDraw(char *, int);
		void doDraw(char *);

	private:
		int humidity, wspeed, wspeedm,	tzone;
		double celsius, fahrenheit, visibility, press, pressm, dp, dpm;
		char *weathdir;
		char *station, updated[32], location[128], wdir[8], conditions[64];
		PIXMAP  pixmap;
		GEOM frame;
		GEOM label;
};

#endif /* __MAIN_HH */
