//  Basewindow.cpp for bbtools.
//
//  Copyright (c) 1998-1999 by John Kennis, j.m.b.m.kennis@ele.tue.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//
#include "Basewindow.h"
#include "resource.h"

Basewindow::Basewindow(struct OPTIONS *options)
{
	display_name=NULL;
	config_filename=NULL;
	config_file=options->cnfg;
	position=NULL;
	withdrawn=False;
	shape=False;	
	cycle=False;
	extra=False;
	server_grabs=0;
	ticks = 60;
	updt = 10;
	
	dpy=NULL;
	dpy=XOpenDisplay(display_name);
	if (dpy==NULL)
	{
		fprintf(stderr,"Error can't open display %s\n",display_name);
		exit(1);
	}

	screen=DefaultScreen(dpy);
	v=DefaultVisual(dpy,screen);
	root=RootWindow(dpy,screen);
	depth=DefaultDepth(dpy,screen);
	display_height=DisplayHeight(dpy,screen);
	display_width=DisplayWidth(dpy,screen);

	xres = WidthOfScreen(ScreenOfDisplay(dpy, screen));
	yres = HeightOfScreen(ScreenOfDisplay(dpy, screen));	

	MakeCursor();
}

Basewindow::~Basewindow()
{
}

void Basewindow::MakeCursor(void)
{
	cursor = XCreateFontCursor(dpy, XC_left_ptr);
	XDefineCursor(dpy, root, cursor);
}


void Basewindow::setupImageControl()
{
	image_control = new BImageControl(this);
	image_control->installRootColormap();
}


void Basewindow::grab(void)
{
	if (! server_grabs++);
	   XGrabServer(dpy);

	XSync(dpy, False);
}

void Basewindow::ungrab(void)
{
	if (! --server_grabs);
  	XUngrabServer(dpy);

	if (server_grabs < 0) server_grabs = 0;
}
