#ifndef _incl_list
#define _incl_list

#include "macros.h"
#include "types.h"

#define  DATA(L)  ((L)->data_ptr)
#define  NEXT(L)  ((L)->next)

#define  CHECK_INSERT_LIST(list, data_ptr, type) \
	 {   if (insert_list(&list, (Generic_ptr) data_ptr) == ERROR) \
	     {   FREE(data_ptr, type); \
		 return  ERROR;   }   }

typedef struct node
{
    Generic_ptr data_ptr;
    struct node *next;
}   Node, *List;

extern Status allocate_node
	(List *p_list, Generic_ptr data_ptr);

extern void free_node
	(List *p_list);

extern Status init_list
	(List *p_list);

extern Bool empty_list
	(List list);

extern Status insert_list
	(List *p_list, Generic_ptr data_ptr);

extern Status append_list
	(List *p_list, Generic_ptr data_ptr);

extern Status delete_key
	(List *p_list, Generic_ptr key_ptr);

extern Status delete_node
	(List *p_list, List list);

extern Status delete_list
	(List *p_list, Generic_ptr *p_data_ptr);

extern Status traverse_list
	(List list, Check_func func);

extern List list_iterator
	(List list, List last_return);

extern Status find_key
	(List list, Generic_ptr key_ptr, Equal_func cmp, List *p_key_list);

extern void destroy_list
	(List *p_list, Data_func func);

#endif /* _incl_list */
