#include "process.h"

#include "block.h"
#include "block2.h"
#include "block3.h"
#include "command.h"
#include "files.h"
#include "par.h"
#include "script.h"
#include "store.h"

#define  MEGAWORD		(1024 * 1024)
#define  DEFAULT_STORE		(2 * MEGAWORD)

static String script_file;
static String input_file;
static String output_file;
static String par_file;
static FILE *fp = NULL;

static char *check_plural(int n)
{
    static char singular[] = "";
    static char plural[] = "s";

    if (n == 1)
	return  singular;
    else
	return  plural;
}

static void print_info_msg(String msg)
{
    printf("%s\n", msg);

    if (fp)
	write_par_comment(fp, msg);
}

static void init_info()
{
    Line msg, error_msg;

    if (*output_file)
	if ((fp = open_par_file(par_file, output_file, error_msg)) == NULL)
	    ERROR_AND_EXIT(error_msg);

    print_info_msg("");

    sprintf(msg, "script file = %s", script_file);
    print_info_msg(msg);

    sprintf(msg, "input data file = %s", input_file);
    print_info_msg(msg);

    sprintf(msg, "output data file = %s", output_file);
    print_info_msg(msg);

    print_info_msg("");
}

static void print_info(int first, int ndone, Script *scripts)
{
    int i, j, n;
    String ptr;
    Line msg;

    printf("Working on %d script%s:\n", ndone, check_plural(ndone));

    for (i = 0; i < ndone; i++)
    {
	n = scripts[i].ncommands;
	sprintf(msg, "\tScript %d (dimension%s", i+first+1,
					check_plural(scripts[i].ndim));

	ptr = msg + strlen(msg);
	for (j = 0; j < scripts[i].ndim; j++)
	{
	    sprintf(ptr, "%s %d", ((j > 0) ? "," : ""), scripts[i].dims[j] + 1);
	    ptr += strlen(ptr);
	}

	sprintf(ptr, ") has %d command%s:", n, check_plural(n));
	print_info_msg(msg);

	for (j = 0; j < n; j++)
	{
	    sprintf(msg, "\t\tCommand %d: %s",
					j+1, scripts[i].commands[j].msg);
	    print_info_msg(msg);
	}
    }

    FLUSH;
    fflush(fp);
}

#define  SIZE_OF_BLOCK  4096

void main(int argc, char **argv)
{
    int i, nscripts, ndone, method;
    Line error_msg;
    Bool have_output, have_some_output;
    Size_info size_info;
    Store_info store_info;
    Ref_info *ref_info;
    File_info file_info;
    Par_info par_info;
    Script *scripts;

    printf(product);

    if (help_request(argc, argv, help_table))
	exit (0);

    if ((argc != 2) && (argc != 3))
    {
	sprintf(error_msg, "correct usage: %s", argv[0]);
	strcat(error_msg, " [<memory in Mwords>] <script file>");
	ERROR_AND_EXIT(error_msg);
    }

    if (argc == 3)
	store_info.nstore = MAX(1, atoi(argv[1])) * MEGAWORD;
    else
	store_info.nstore = DEFAULT_STORE;

    script_file = argv[argc-1];

    if (read_script_file(script_file, &size_info, &ref_info, &file_info,
				&nscripts, &scripts, error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);

    if (nscripts == 0)
	ERROR_AND_EXIT("no scripts to process");

    if (size_info.block_size[0] == 0)
	find_block_sizes(size_info.ndim, SIZE_OF_BLOCK,
			size_info.npoints, size_info.block_size, FALSE);
	/* above uses input npoints, maybe should use output npoints */

    if (allocate_store(&store_info, &size_info, nscripts, scripts,
							error_msg) == ERROR)
	ERROR_AND_EXIT(error_msg);

    par_file = file_info.par_file;
    input_file = file_info.input_file;
    output_file = file_info.output_file;

    init_info();

    have_some_output = FALSE;

    for (i = 0; i < nscripts; i += ndone)
    {
	ndone = scripts_processed(&method, &have_output, nscripts-i,
			scripts+i, &size_info, &store_info, &file_info);

	print_info(i, ndone, scripts+i);

	file_info.have_output = have_output;

	if (open_files(&file_info, error_msg) == ERROR)
	    ERROR_AND_EXIT(error_msg);

	if (method == 1)
	{
	    if (process_blocks(&size_info, &store_info, &file_info,
				ndone, scripts+i, error_msg) == ERROR)
	    	ERROR_AND_EXIT(error_msg);
	}
	else if (method == 2)
	{
	    if (process_blocks2(&size_info, &store_info, &file_info,
				ndone, scripts+i, error_msg) == ERROR)
	    	ERROR_AND_EXIT(error_msg);
	}
	else /* method == 3 */
	{
	    if (process_blocks3(&size_info, &store_info, &file_info,
				scripts+i, error_msg) == ERROR) /* ndone = 1 */
	    	ERROR_AND_EXIT(error_msg);
	}

    	close_files(&file_info);

	if (have_output)
	{
	    have_some_output = TRUE;
	    file_info.input_file = file_info.output_file;
	}
    }

    if (have_some_output)
    {
	truncate_file(&size_info, file_info.output_file);

	par_info.file = file_info.output_file;
	par_info.ndim = size_info.ndim;
	par_info.npoints = size_info.npoints;
	par_info.block_size = size_info.block_size;
	par_info.ref = ref_info;
	par_info.blocked = TRUE;
	par_info.deflated = FALSE;
	par_info.level = 0;

	get_params(&par_info.param_dim, &par_info.params);

	write_par_info(fp, &par_info);
	fclose(fp);
    }
}
